import argparse
from google.cloud import vision


def landmark(client, image):
    print('Wykryto znany punkt:')
    response = client.landmark_detection(image=image)
    landmarks = response.landmark_annotations
    for landmark in landmarks:
        print(f'  {landmark.description}')
        for location in landmark.locations:
            coord = location.lat_lng
            print(f'  Szerokość geograficzna {coord.latitude}')
            print(f'  Długość geograficzna {coord.longitude}')

    if response.error.message:
        raise Exception(
            '{}\nWięcej o błędach dowiesz się ze strony: '
            'https://cloud.google.com/apis/design/errors'.format(
                response.error.message))


def main(image_file):
    content = image_file.read()

    client = vision.ImageAnnotatorClient()

    image = vision.Image(content=content)

    response = client.label_detection(image=image)
    labels = response.label_annotations
    print('Etykiety i wyniki powiązane z obrazem:')

    for label in labels:
        print(label.description, label.score)
        if(label.description == 'Landmark'):
            landmark(client, image)

    if response.error.message:
        raise Exception(
            '{}\nWięcej o błędach dowiesz się ze strony: '
            'https://cloud.google.com/apis/design/errors'.format(
                response.error.message))


if __name__ == '__main__':
    parser = argparse.ArgumentParser()
    parser.add_argument(dest='input', type=argparse.FileType('rb'),
                        help='Obraz wejściowy')
    args = parser.parse_args()
    main(args.input)
