import zipfile
import shutil
import os
import argparse
OUTPUT_DIR = 'macro_file'


def main(spreadsheet, script):
    print("Usuwanie i tworzenie katalogu za pomocą makro")
    shutil.rmtree(OUTPUT_DIR, True)
    os.mkdir(OUTPUT_DIR)

    filename = OUTPUT_DIR + '/' + spreadsheet
    print("Otwieranie pliku " + spreadsheet)
    shutil.copyfile(spreadsheet, filename)

    doc = zipfile.ZipFile(filename, 'a')
    doc.write(script, 'Scripts/python/' + script)
    manifest = []
    for line in doc.open('META-INF/manifest.xml'):
        if '</manifest:manifest>' in line.decode('utf-8'):
            for path in ['Scripts/', 'Scripts/python/',
                         'Scripts/python/' + script]:
                man_line = (' <manifest:file-entry '
                            'manifest:media-type="application/binary" '
                            f'manifest:full-path="{path}"/>')
                manifest.append(man_line)
        manifest.append(line.decode('utf-8'))

    doc.writestr('META-INF/manifest.xml', ''.join(manifest))
    doc.close()
    print("Plik został utworzony: " + filename)


if __name__ == '__main__':
    parser = argparse.ArgumentParser('Dołącza plik makro "script" do pliku '
                                     '"spreadsheet" w formacie .ods. '
                                     'Wynikowy plik jest zapisywany w katalogu '
                                     f'{OUTPUT_DIR}, który zostanie '
                                     'utworzony.')
    parser.add_argument(dest='spreadsheet', type=str,
                        help='Plik, w którym umieszczany jest skrypt')
    parser.add_argument(dest='script', type=str,
                        help='Skrypt dołączany do pliku')
    args = parser.parse_args()
    main(args.spreadsheet, args.script)
