#include <owl\owlpch.h>
#include "ini\ini.h"

const char plik_inicj[] = "ini.ini"; //  nazwa pliku .ini
// jeli nie podamy cieki, to plik zostanie utworzony w katalogu
// systemu Windows

class MojeOkno : public TFrameWindow
{
public:
	 MojeOkno(char * title);
	 void CmPlikKoniec();
	 void EvDestroy();
  DECLARE_RESPONSE_TABLE(MojeOkno);
private:
	int cx,cy;
};

DEFINE_RESPONSE_TABLE1(MojeOkno, TFrameWindow)
  EV_WM_DESTROY,
  EV_COMMAND(CM_PLIKKONIEC, CmPlikKoniec),
END_RESPONSE_TABLE;

void MojeOkno::CmPlikKoniec()
{
CloseWindow(0);
}


MojeOkno::MojeOkno(char * title) : TFrameWindow(0, title)
{
int x, y, cx,cx_def, cy,cy_def;
// 	pozycja domylna = (20,20)
x  = GetPrivateProfileInt("Pozycja", "x", 20, plik_inicj);
y  = GetPrivateProfileInt("Pozycja", "y", 20, plik_inicj);
// rozmiar domylny = 75% wielkoci max. ekranu
cx_def = 3*GetSystemMetrics(SM_CXSCREEN)/4;
cy_def = 3*GetSystemMetrics(SM_CYSCREEN)/4;
cx = GetPrivateProfileInt("Pozycja", "cx", cx_def, plik_inicj);
cy = GetPrivateProfileInt("Pozycja", "cy", cy_def, plik_inicj);
Attr.X = x;
Attr.Y = y;
Attr.W = cx;
Attr.H = cy;
}



void MojeOkno::EvDestroy()
{
char buf[20];
// uaktualniamy zawarto pliku .ini
wsprintf(buf, "%d",Attr.X);
WritePrivateProfileString("Pozycja", "x", buf, plik_inicj);
wsprintf(buf, "%d",Attr.Y);
WritePrivateProfileString("Pozycja", "y", buf, plik_inicj);
wsprintf(buf, "%d",Attr.W);
WritePrivateProfileString("Pozycja", "cx", buf, plik_inicj);
wsprintf(buf, "%d",Attr.H);
WritePrivateProfileString("Pozycja", "cy", buf, plik_inicj);
TWindow::EvDestroy();
}

class MojaAplikacja : public TApplication
{
public:
 MojaAplikacja();
 void InitMainWindow();
};

MojaAplikacja::MojaAplikacja() : TApplication()
{
}

void MojaAplikacja::InitMainWindow()
{
SetMainWindow(new MojeOkno("Demonstracja uycia pliku konfiguracyjnego .ini"));
MainWindow->AssignMenu("MAIN");
MainWindow->SetIcon(this, "IKONA1");
}

OwlMain(int, char **)
{
return MojaAplikacja().Run();
}
