#include <owl\owlpch.h>
#include "druk1\druk1.h"
class MojeOkno : public TFrameWindow
{
private:
	 TPrinter* drukarka;
	int cx,cy;							// rozmiary obszaru roboczego
public:
	 MojeOkno(char * title);
	 ~MojeOkno();
	 void EvSize(uint sizeType, TSize& size);

	 void EvRButtonDown(uint, TPoint&);

	 void Paint(TDC&, BOOL, TRect&);

	 void CmPlikDrukuj();
	 void CmUstawieniaWydruku();
	 void CmPlikKoniec(){CloseWindow(0);}

  DECLARE_RESPONSE_TABLE(MojeOkno);
};
DEFINE_RESPONSE_TABLE1(MojeOkno, TFrameWindow)
  EV_WM_SIZE,
  EV_WM_RBUTTONDOWN,
  EV_COMMAND(CM_PLIKDRUKUJ, CmPlikDrukuj),
  EV_COMMAND(CM_PLIKPSETUP, CmUstawieniaWydruku),
  EV_COMMAND(CM_PLIKKONIEC,    CmPlikKoniec),

END_RESPONSE_TABLE;
// ----------------------------------------------------------------------------
class DokumentPrn : public TPrintout
{
public:
 DokumentPrn(const char* title, TWindow* okno);
 void GetDialogInfo(int& minPage, int& maxPage,int& selFromPage, int& selToPage);
 void PrintPage(int page, TRect& rect, unsigned flags);
 void TrybDruku(BOOL b) {Banding = b;}
 BOOL HasPage(int pageNumber) {return pageNumber == 1;}
protected:
 TWindow* Okno;
};
// ----------------------------------------------------------------------------
DokumentPrn::DokumentPrn(const char* title, TWindow* okno):TPrintout(title)
{
Okno = okno;
}
// ----------------------------------------------------------------------------
void DokumentPrn::PrintPage(int, TRect& rect, unsigned)
{
int    old_mode;
TSize  oldVExt, oldWExt;
// arbitrarnie skalujemy osie: 1 jedn. na osi  x =  1 jedn. na osi y
old_mode = DC->SetMapMode(MM_ISOTROPIC);
// pobieramy obszar roboczy
TRect rozm_okna = Okno->GetClientRect();
// ustalamy nowy rozmiar strony
DC->SetViewportExt(PageSize, &oldVExt);
// ustalamy rozmiar okna zwizanego z DC
DC->SetWindowExt(rozm_okna.Size(), &oldWExt);
// wywoujemy funkcj Paint okna:
Okno->Paint(*DC, FALSE, rect);
// odtwarzamy poprzedni kontekst DC
DC->SetWindowExt(oldWExt);
DC->SetViewportExt(oldVExt);
DC->SetMapMode(old_mode);
// Uwaga: sprbuj wydrukowa dokument bez skalowania, tzn. usu wszystko
// oprcz linijki Okno->Paint(*DC, FALSE, rect)!
}
// ----------------------------------------------------------------------------
void DokumentPrn::GetDialogInfo(int& minPage, int& maxPage,
										 int& selFromPage, int& selToPage)
{
// jeli dokument mA tylko jedn stron stron, to nie nalezy
// uaktywnia opcji "zakres stron"
minPage = maxPage = 0;
selFromPage = selToPage = 0;
}
//----------------------------------------------------------------------------
MojeOkno::MojeOkno(char * title) : TFrameWindow(0, title)
{
drukarka = new TPrinter; // reprezentuje drukark
}
//----------------------------------------------------------------------------
MojeOkno::~MojeOkno()
{
delete drukarka;
}
//----------------------------------------------------------------------------
void MojeOkno::EvSize(uint,TSize&)
// zarejestruj zmienione parametry okna
{
TRect trClient = GetClientRect(); // wybr obszaru roboczego
cx=trClient.Width();
cy=trClient.Height();
}
//----------------------------------------------------------------------------
void MojeOkno::EvRButtonDown(uint, TPoint&)
// Prawy klawisz myszki jest rwnowany opcji Plik/Drukuj
{
CmPlikDrukuj();
}
//----------------------------------------------------------------------------

void MojeOkno::CmPlikDrukuj()
{
if(drukarka)
  {
  DokumentPrn printout("Test druku", this);
  printout.TrybDruku(TRUE);
  drukarka->Print(this, printout, TRUE);
  }
}
//----------------------------------------------------------------------------
void MojeOkno::CmUstawieniaWydruku()
{
if (drukarka)
  drukarka->Setup(this);
}
// ----------------------------------------------------------------------------
void MojeOkno::Paint(TDC& dc, BOOL, TRect&)
{
TRect  m_r(30,80,6*cx/7,160);
dc.Rectangle(m_r);

LOGFONT lf;
memset(&lf,0,sizeof(LOGFONT));    // wane!
strcpy(lf.lfFaceName,"Times New Roman CE");
		 lf.lfHeight=28;
		 lf.lfUnderline=0;
		 lf.lfItalic=1;
		 lf.lfStrikeOut=0;
		 lf.lfCharSet=DEFAULT_CHARSET; // w zasadzie gwarantuje polskie znaki
		 lf.lfQuality=DRAFT_QUALITY;   // DEFAULT_QUALITY, PROOF_QUALITY

TFont *ptfont=new TFont(&lf);
dc.SelectObject(*ptfont);
dc.SetTextColor(TColor::LtBlue);  // kolor tekstu
dc.TextOut(35,100,"Wybierz opcj Plik/Drukuj lub nacinij prawy klawisz myszki!");
}
//----------------------------------------------------------------------------
class MojaAplikacja : public TApplication
{
 public:
 MojaAplikacja() : TApplication() {}
 void InitMainWindow()
	  {
	  SetMainWindow(new MojeOkno("Drukowanie dokumentw z OWL"));
	  MainWindow->AssignMenu("MAIN");
	  MainWindow->SetIcon(this, "IKONA1");
	 }
};
//----------------------------------------------------------------------------
int OwlMain(int, char**)
{
return MojaAplikacja().Run();
}
//----------------------------------------------------------------------------

