#include <owl\owlpch.h>
#include "tlo\tlo.h"
// --------------------------------------------------------------------------
const int NBR_KOLOR=8;
const int NBR_GWIAZD=100;

typedef struct
{
TPoint  		gdzie;
COLORREF 	kolor;
}Gwiazda,*GwiazdaPtr;

class MojeOkno : public TFrameWindow
{
private:
	 COLORREF   kolory[NBR_KOLOR]; /// tablica kolorw
	 COLORREF   tlo;
	 int        cx;
	 int        cy;
	 int        Zegarek;
	 int        NbrKolorow;
	 GwiazdaPtr     Niebo;
public:
	 MojeOkno(char * title);
	 ~MojeOkno();
	 void SetupWindow();
	 void CmPlikKoniec();
	 BOOL EvEraseBkgnd(HDC hdc);
	 void EvSize(UINT, TSize&);
	 BOOL IdleAction (long);
	 void Paint(TDC&, BOOL, TRect&);
	 void RysujGwiazde(TDC&, TPoint&, COLORREF);
  DECLARE_RESPONSE_TABLE(MojeOkno);
};

DEFINE_RESPONSE_TABLE1(MojeOkno, TFrameWindow)
  EV_WM_ERASEBKGND,
  EV_WM_SIZE,
  EV_COMMAND(CM_PLIKKONIEC,CmPlikKoniec),
END_RESPONSE_TABLE;

MojeOkno::MojeOkno(char * title) : TFrameWindow(0, title)
{
tlo = TColor::Black;
cx  = GetSystemMetrics(SM_CXFULLSCREEN);
cy = GetSystemMetrics(SM_CYFULLSCREEN);;
Zegarek = 0;
}

MojeOkno::~MojeOkno()
{
delete Niebo;
}

void MojeOkno::SetupWindow()
{
TFrameWindow::SetupWindow();
TClientDC dc (*this);
NbrKolorow=dc.GetDeviceCaps(NUMCOLORS);
Niebo = new Gwiazda[NBR_GWIAZD];
if (NbrKolorow > 2) // monitor color
 {
 kolory[0]=(COLORREF(TColor::LtGray));
 kolory[1]=(COLORREF(TColor::LtMagenta));
 kolory[2]=(COLORREF(TColor::LtRed));
 kolory[3]=(COLORREF(TColor::LtCyan));
 kolory[4]=(COLORREF(TColor::Gray));
 kolory[5]=(COLORREF(TColor::LtBlue));
 kolory[6]=(COLORREF(TColor::LtGreen));
 kolory[7]=(COLORREF(TColor::LtYellow));
 }
}

void MojeOkno::CmPlikKoniec()
{
CloseWindow(0);
}

BOOL MojeOkno::EvEraseBkgnd(HDC hdc)
{
// malujemy to na czarno
PatBlt(hdc, 0, 0, cx, cy, BLACKNESS);
return TRUE;
}

void MojeOkno::EvSize(UINT sizeType, TSize& size)
{
TFrameWindow::EvSize(sizeType, size);
cx  = size.cx;
cy = size.cy;
Invalidate(); // wymuszamy Paint()
}

BOOL MojeOkno::IdleAction(long)
{
// Funkcja wywoywana, gdy aden komunikat nie znajduje si w kolejce systemowej
// IdleAction dziaa dopty dopki jest zwracana warto true.
// parametr tej funkcji okrela ilo jej wywoa pomidzy komunikatami

if (++Zegarek < 200)
	return TRUE; // ptla opniajca wywietlanie
TClientDC dc(*this);
// wymazujemy star "gwiazd":
int i = random(NBR_GWIAZD);
RysujGwiazde(dc, Niebo[i].gdzie, tlo);
// nowe losowe wsprzdne
Niebo[i].gdzie.x = random(cx);
Niebo[i].gdzie.y = random(cy);
// nowy losowy kolor
Niebo[i].kolor = (COLORREF)kolory[random(NbrKolorow)];
//
RysujGwiazde(dc, Niebo[i].gdzie, Niebo[i].kolor);
Zegarek = 0; // zerujemy ptl wewntrzn
return TRUE;
}

void MojeOkno::Paint(TDC& dc, BOOL, TRect&)
{
// to na czarno
dc.PatBlt(0, 0, cx, cy, BLACKNESS);
// rysujemy gwiazdy
for (int i=0; i<NBR_GWIAZD; i++)
  RysujGwiazde(dc, Niebo[i].gdzie, Niebo[i].kolor);
}

void MojeOkno::RysujGwiazde(TDC& dc, TPoint& pt, COLORREF kolor)
{
// rysujemy "grub kropk" (1 piksel jest zbyt sabo widoczny
dc.SetPixel (pt, kolor);
dc.SetPixel(pt.x+1, pt.y, kolor);
dc.SetPixel(pt.x, pt.y+1, kolor);
dc.SetPixel(pt.x-1, pt.y, kolor);
dc.SetPixel(pt.x, pt.y-1, kolor);
}

class MojaAplikacja : public TApplication
{
public:
 MojaAplikacja() : TApplication() { }
 void InitMainWindow()
 {
  SetMainWindow(new MojeOkno("Gwiezdne wojny"));
  MainWindow->AssignMenu ("MAIN");
  MainWindow->SetIcon(this, "IKONA1");
 }
};

OwlMain(int, char **)
{
return MojaAplikacja().Run();
}
