#include "adresy\defs.h"

// Handlery komunikatw dla klasy MojeOkno
DEFINE_RESPONSE_TABLE1 (MojeOkno, TFrameWindow)
  EV_LBN_SELCHANGE(IDC_LISTA,     EvLBNSelChange),
  EV_WM_DESTROY,
  EV_WM_SIZE,
  EV_WM_RBUTTONDOWN,
  EV_MESSAGE(M_WPROWADZONODANE, CmUaktualnijBazeDanych),
  EV_COMMAND(CM_PLIKKONIEC, CmPlikKoniec),
  EV_COMMAND(CM_PLIKPRNCONFIG, CmUstawieniaWydruku),

  EV_COMMAND(CM_EDYCJAWPROWADZ, CmEdycjaWprowadz),
  EV_COMMAND(CM_EDYCJAUSUN, CmEdycjaUsun),
  EV_COMMAND(CM_EDYCJADRUKUJ, CmEdycjaDrukuj),
  EV_COMMAND(CM_EDYCJAPOPRAW, CmEdycjaPopraw),

  EV_COMMAND(CM_EDYCJAWPROWADZ_X, CmEdycjaWprowadz),
  EV_COMMAND(CM_EDYCJAUSUN_X, CmEdycjaUsun),
  EV_COMMAND(CM_EDYCJADRUKUJ_X, CmEdycjaDrukuj),
  EV_COMMAND(CM_EDYCJAPOPRAW_X, CmEdycjaPopraw),
  EV_COMMAND(CM_NATEMATPROGRAMU, CmNaTematProgramu),
END_RESPONSE_TABLE;
// *************************************************************************
// =========================================================================
// realizacja metod dla klasy MojeOkno
MojeOkno::MojeOkno(char * title) : TFrameWindow(0, title)
{
ptr_form1 = 0;
lista=0;
// inicjacja menu podrcznego
menupod = new TMenu(GetApplication()->GetInstance(),"MAIN_X");
// zaadowanie obrazka z pliku MAIN.RC
TModule *m=GetModule();
domek=m->LoadBitmap(DOMEK_NA_WSI);

int x, y, cx,cx_def, cy,cy_def;
// odczyt parametrw startowych z pliku .ini
// 	pozycja domylna = (20,20)
x  = GetPrivateProfileInt("Pozycja", "x", 20, plik_inicj);
y  = GetPrivateProfileInt("Pozycja", "y", 20, plik_inicj);
char buf[11];
GetPrivateProfileString("Data", "ostatnia sesja", "??\\??\\??", buf,11,plik_inicj);
strcpy(ldata,buf);

// rozmiar domylny = 75% wielkoci max. ekranu
cx_def = 3*GetSystemMetrics(SM_CXSCREEN)/4;
cy_def = 3*GetSystemMetrics(SM_CYSCREEN)/4;
cx = GetPrivateProfileInt("Pozycja", "cx", cx_def, plik_inicj);
cy = GetPrivateProfileInt("Pozycja", "cy", cy_def, plik_inicj);

Attr.X = x;
Attr.Y = y;
Attr.W = cx;
Attr.H = cy;

}
// ----------------------------------------------------------------------
void MojeOkno::EvDestroy()
{
char buf[20];
// uaktualniamy zawarto pliku .ini
wsprintf(buf, "%d",Attr.X);
WritePrivateProfileString("Pozycja", "x", buf, plik_inicj);
wsprintf(buf, "%d",Attr.Y);
WritePrivateProfileString("Pozycja", "y", buf, plik_inicj);
wsprintf(buf, "%d",Attr.W);
WritePrivateProfileString("Pozycja", "cx", buf, plik_inicj);
wsprintf(buf, "%d",Attr.H);
WritePrivateProfileString("Pozycja", "cy", buf, plik_inicj);
struct date d;
getdate(&d);
wsprintf(buf,"%2d\\%2d\\%4d",d.da_day,d.da_mon,d.da_year);
WritePrivateProfileString("Data", "ostatnia sesja",buf,plik_inicj);

adr.close(); 			// zamykamy baz danych
TWindow::EvDestroy();
}
// ----------------------------------------------------------------------
MojeOkno::~MojeOkno()
{
delete imie;
delete nazwisko;
delete adres;
delete miasto;
delete telefon;
delete fax;
delete lista;
delete menupod;
delete drukarka;
}
// ----------------------------------------------------------------------
void MojeOkno::SetupWindow()
{
TWindow::SetupWindow();
KursorOczekiwania();
// rysujemy statyczny opis okna:
new TStatic(this, -1, "Baza danych:",  3,   3, 158, 18, 25)->Create();

new TStatic(this, -1, "Imi:       ", 250+200, 30, 150, 20, 25)->Create();
new TStatic(this, -1, "Nazwisko:   ", 250+200, 60, 150, 20, 25)->Create();
new TStatic(this, -1, "Adres:      ", 250+200, 90, 150, 20, 25)->Create();
new TStatic(this, -1, "Miasto:     ", 250+200,120, 150, 20, 25)->Create();
new TStatic(this, -1, "Telefon:    ", 250+200,150, 150, 20, 25)->Create();
new TStatic(this, -1, "Fax:        ", 250+200,180, 150, 20, 25)->Create();

// te pola nie s statyczne i bda pniej modyfikowane

imie     = new TStatic(this, -1, "", 350+200, 30, 250, 20, 25);
nazwisko = new TStatic(this, -1, "", 350+200, 60, 250, 20, 25);
adres    = new TStatic(this, -1, "", 350+200, 90, 250, 20, 25);
miasto   = new TStatic(this, -1, "", 350+200,120, 250, 20, 25);
telefon  = new TStatic(this, -1, "", 350+200,150, 250, 20, 25);
fax      = new TStatic(this, -1, "", 350+200,180, 250, 20, 25);

// dopiero teraz je wywietlamy

imie->Create();
nazwisko->Create();
adres->Create();
miasto->Create();
telefon->Create();
fax->Create();

// kontynuujmey opis okienka
char buf[100];
wsprintf(buf,"Data ostatniej sesji: %s",ldata);
new TStatic(this, -1, buf,  3,   290, 400, 20, 25)->Create();
// tworzymy i adujemy list danymi z bazy danych
lista = new TListBox(this, IDC_LISTA, 10, 30, 200+200, 250);
lista->Create();
adr.open(); 			// otwieramy baz danych
adr.set_idx("UNIQUE_ID");
adr.rew();
while(adr.next() == IM_OK)
	{
	char buf[MAXLEN+MAXLEN+2];
	memset(buf,0,MAXLEN+MAXLEN+2);
	wsprintf(buf,"%s,%s",adr.bdd_nazwisko,adr.bdd_imie);
	lista->AddString(buf);
	}
KursorNormalny();
drukarka = new TPrinter;
}
// ----------------------------------------------------------------------
void MojeOkno::EvLBNSelChange()
{
KursorOczekiwania();
int   i,index = lista->GetSelIndex();  // biecy wybr
char buf[MAXLEN+MAXLEN+2];
if (index != LB_ERR) // czy naprawd co wybrano?
	{						// jeli tak, to kopiujemy to do 'buf'
	lista->GetSelString(buf,MAXLEN+MAXLEN);
	for(i=0;i<MAXLEN+MAXLEN;i++) // szukamy przecinka w parze 'nazwisko,imi' z listy
		if(buf[i]==',') break;
	adr.clear_buf();
	memcpy(adr.bdd_nazwisko,buf,i);
	adr.bdd_nazwisko[i]='\0';
	strcpy(adr.bdd_imie,buf+i+1);
	adr.rew();
	if(adr.find() == IM_OK)
	  {
		imie->SetText(adr.bdd_imie);
		nazwisko->SetText(adr.bdd_nazwisko);
		adres->SetText(adr.bdd_adres);
		miasto->SetText(adr.bdd_miasto);
		telefon->SetText(adr.bdd_telefon);
		fax->SetText(adr.bdd_fax);
	  }
	}
KursorNormalny();
}
// ----------------------------------------------------------------------
void MojeOkno::EvSize(uint,TSize&)
// zarejestruj zmienione parametry okna
{
TRect trClient = GetClientRect(); // wybr obszaru roboczego
cx=trClient.Width();
cy=trClient.Height();
}
// ----------------------------------------------------------------------
void MojeOkno::EvRButtonDown(UINT, TPoint &pt)
// prawy klawisz myszki wywouje menu podrczne
{
// konwersja wsprzdnych w celu umiejscowienia menu na ekranie
ClientToScreen(pt);
// menu kontekstowe
::TrackPopupMenu (::GetSubMenu(HMENU(*menupod),0),
						 TPM_LEFTALIGN | TPM_RIGHTBUTTON,pt.x, pt.y, 0,*this,0);
}
// ----------------------------------------------------------------------
void MojeOkno::CmPlikKoniec()
{
CloseWindow(0);
}
// ----------------------------------------------------------------------
void MojeOkno::CmEdycjaWprowadz()
// tworzymy okienko edycyjne blokujce
{
poprawianie=false; // jestemy w trybie tworzenia nowego rekordu
ptr_form1 = new FormularzAdresowy (this, FORM_OSOBA);
ptr_form1->Execute(); // tworzy okienko modalne
}
// ----------------------------------------------------------------------
void MojeOkno::CmEdycjaPopraw()
{
poprawianie=true; // jestemy w trybie poprawiania istniejcego rekordu
int index = lista->GetSelIndex();
if (index != LB_ERR)
  {
  ptr_form1 = new FormularzAdresowy (this, FORM_OSOBA);
  ptr_form1->Execute(); // tworzy okienko modalne
  }else
	  MessageBox ("aden adres nie jest zaznaczony!",
						"Informacja", MB_ICONINFORMATION);
poprawianie=false;
}
// ----------------------------------------------------------------------
void MojeOkno::CmEdycjaUsun()
// usuwamy wybrany rekord z listy
{
KursorOczekiwania();
int   i,index = lista->GetSelIndex();  // biecy wybr
char buf[MAXLEN+MAXLEN+2];
if (index != LB_ERR) // czy naprawd co wybrano?
	{						// jeli tak, to kopiujemy to do 'buf'
	lista->GetSelString(buf,MAXLEN+MAXLEN);
	for(i=0;i<MAXLEN+MAXLEN;i++) // szukamy przecinka w parze 'nazwisko,imi' z listy
		if(buf[i]==',') break;
	// "dekodujemy" klucz = [imi, nazwisko] ( w licie byy sklejone w jeden acuch)
	memcpy(adr.bdd_nazwisko,buf,i);
	adr.bdd_nazwisko[i]='\0';
	strcpy(adr.bdd_imie,buf+i+1);

	adr.rew(); // skok na pocztek bazy
	if(adr.find() == IM_OK) // szukamy wg klucza [imi, nazwisko]
	  {
	  if(adr.erase()== IM_OK)
		 lista->DeleteString(index);
	  else
		  // w zasadzie taki bd nie powinien si zdarzy
		  MessageBox ("Wystpi bd dyskowy: rekord nie zosta usunity!","Ostrzeenie", MB_ICONHAND);
	  }
KursorNormalny();
	}
else
	MessageBox ("aden adres nie jest zaznaczony!","Informacja", MB_ICONINFORMATION);
}
// ----------------------------------------------------------------------
void MojeOkno::CmUstawieniaWydruku()
{
if (drukarka)
  drukarka->Setup(this);
}
// ----------------------------------------------------------------------
void MojeOkno::CmEdycjaDrukuj()
{
int   index = lista->GetSelIndex();  // biecy wybr
if (index != LB_ERR) // czy naprawd co wybrano?
 {
	if(drukarka)
	{
	drukowanie=true;
	DokumentPrn printout("Adres", this);
	printout.TrybDruku(TRUE);
	drukarka->Print(this, printout, TRUE);
	drukowanie=false;
	}
 }
else
	MessageBox ("aden adres nie jest zaznaczony!","Informacja", MB_ICONINFORMATION);
}
// ----------------------------------------------------------------------
void MojeOkno::CmNaTematProgramu()
{
TDialog(this, IDD_NATEMAT).Execute();
}
// ----------------------------------------------------------------------
LRESULT MojeOkno::CmUaktualnijBazeDanych(WPARAM, LPARAM)
{
KursorOczekiwania();
if(poprawianie==true)
	{
	adr.erase();                       // usuwamy start rekord z bazy
	int index = lista->GetSelIndex();  // usuwamy element z listy
	if (index != LB_ERR)
		 lista->DeleteString(index);
	}
adr.rew(); 			// ustawiamy si na pocztek bazy
if(adr.insert()!=IM_OK)
		MessageBox ("Bd zapisu do bazy danych, prawdopodobnie taki adres ju istnieje!",
						"Ostrzeenie",MB_ICONSTOP);
else  // lista posortuje "si" sama
		{
		char buf[MAXLEN+MAXLEN+2];
		memset(buf,0,MAXLEN+MAXLEN+2);
		wsprintf(buf,"%s,%s",adr.bdd_nazwisko,adr.bdd_imie);
		lista->AddString(buf);
		}
KursorNormalny();
return 0L;
}
// ----------------------------------------------------------------------
bool MojeOkno::CanClose()
{
return MessageBox("Czy chcesz zakoczy prac programu?", "Koniec pracy programu",
						  MB_YESNO | MB_ICONQUESTION) == IDYES;
}
// ----------------------------------------------------------------------
void MojeOkno::Paint(TDC& dc, BOOL, TRect&)
// funkcja Paint (odnawiana zawartoci okna) suy zarwno dla celw
// drukowania, jak i dla zwykego odwieania okna
{
if(drukowanie) // znajdujemy si w trybie drukowanie => "drukuj" do DC  tylko wizytwk
{
LOGFONT lf;
memset(&lf,0,sizeof(LOGFONT));    // wane!
strcpy(lf.lfFaceName,"Arial CE");
		 lf.lfHeight=18;
		 lf.lfCharSet=DEFAULT_CHARSET; // w zasadzie gwarantuje polskie znaki
		 lf.lfQuality=DRAFT_QUALITY;   // DEFAULT_QUALITY, PROOF_QUALITY
TFont *ptfont=new TFont(&lf);
dc.SelectObject(*ptfont);
// otoczka adresu

char buf[MAXLEN+MAXLEN+2];
wsprintf(buf,"%s %s",adr.bdd_imie,adr.bdd_nazwisko);

TSize res1=dc.GetTextExtent(buf,strlen(buf));
TSize res2=dc.GetTextExtent(adr.bdd_miasto,strlen(adr.bdd_miasto));

// ramka wok adresu
TRect  m_r(40,242-200,40+max(res1.cx,res2.cx)+4,330-200);
dc.Rectangle(m_r);
// adres zostanie wydrukowany na drukarce i wywietlony na ekranie w
// tym samym miejscu co lista (pod ni), zatem nie zaburzy w niczym
// wygldu ekranu
dc.TextOut(44,250-200,buf);
dc.TextOut(44,280-200,adr.bdd_adres);
dc.TextOut(44,310-200,adr.bdd_miasto);
}else
	 if(domek) // tryb normalny, narysuj domek... (mapa bitowa DOMEK_NA_WSI z pliku MAIN.RC
	 {
	 TMemoryDC memDC;
	 memDC.SelectObject(TBitmap(domek));
	 dc.BitBlt(500, 200, 100, 100, memDC, 0, 0 );
	}
}
// ----------------------------------------------------------------------

