// ------------------------------------------------------------------------
// FUNGR16.CPP  Program testuje niektre funkcje graficzne
//              wystpujce w wersji 16 i 32 bit
//
#include <owl\owlpch.h>
#include <math.h>
#include  "pisztxt\pisztxt.h"
// ------------------------------------------------------------------------
class MojeOkno : public TFrameWindow // Okno gwne programu
{
public:
	MojeOkno(char * title);
	~MojeOkno(){}

	void EvSize(uint sizeType, TSize& size);

	void CmPlikKoniec(){CloseWindow(0);}

	void CmTextOut();
	void CmExtTextOut();
	void CmTabbedTextOut();
	void CmDrawText();
	void CmGrayString();

private:
	int cx,cy;							// rozmiary obszaru roboczego

  DECLARE_RESPONSE_TABLE(MojeOkno);
};

// ------------------------------------------------------------------------
DEFINE_RESPONSE_TABLE1(MojeOkno, TFrameWindow)
  EV_WM_SIZE,
  EV_COMMAND(CM_PLIKKONIEC,   CmPlikKoniec),
  EV_COMMAND(CM_TEXTOUT,    	CmTextOut),
  EV_COMMAND(CM_EXTTEXTOUT,   CmExtTextOut),
  EV_COMMAND(CM_TABBEDTEXTOUT,CmTabbedTextOut),
  EV_COMMAND(CM_DRAWTEXT,     CmDrawText),
  EV_COMMAND(CM_GRAYSTRING,	CmGrayString),
  END_RESPONSE_TABLE;
// ------------------------------------------------------------------------
MojeOkno::MojeOkno(char * title) : TFrameWindow(0, title)
{
}
// ------------------------------------------------------------------------
void MojeOkno::EvSize(uint sizeType, TSize& size)
// zarejestruj zmienione parametry okna
{
TRect trClient = GetClientRect(); // wybr obszaru roboczego
cx=trClient.Width();
cy=trClient.Height();
}
// ------------------------------------------------------------------------
void MojeOkno::CmTextOut()
// TextOut(int x, int y, const char far* string, int count = -1)
// lub
// TextOut(const TPoint& p, const char far* string, int count = -1)
// Wykrela w punkcie (x,y) (= lewy grny rg) a do 'count' znakw ze
// wskanika 'string\0'. Jeli count=-1, to wypisywany jest cay tekst
{
TClientDC dc(*this);
LOGFONT lf;
memset(&lf,0,sizeof(LOGFONT));    // wane!
strcpy(lf.lfFaceName,"Times New Roman CE");
		 lf.lfHeight=40;
		 lf.lfUnderline=0;
		 lf.lfItalic=1;
		 lf.lfStrikeOut=0;
TFont *ptfont=new TFont(&lf);
dc.SelectObject(*ptfont);
dc.SetTextColor(TColor::LtBlue);  // kolor tekstu
dc.TextOut(10,10,"Demonstracja funkcji TextOut");
}
// ------------------------------------------------------------------------
void MojeOkno::CmExtTextOut()
// ExtTextOut(int x, int y, uint16 options, const TRect* r, const char far* string, int count, const int far* dx = 0);
// lub
// ExtTextOut(const TPoint& p, uint16 options, const TRect* r, const char far* string, int count, const int far* dx = 0);
// 'options' okrelaj wpyw prostokta TRect otaczajcego tekst: moe on go
// obcina (options=ETO_CLIPPED) lub definiowa nieprzeroczyste to
// (options=ETO_OPAQUE). Opcja ETO_CLIPPED|ETO_OPAQUE jest rwnie moliwa
// do zastosowania.
// dx = tablica wartoci okrelajcych odstpy pomidzy "komrkami" w ktrych
// bdzie wypisywany tekst. Np. dx[i] okrela ilo jednostek oddzielajcych
// "komrki" i-ty i (i+1)-ty znak.
{
TClientDC dc(*this);
int m_dx[]={10,15,25,30,25,20,15,10,10,10,10,10,10,10,10,10,10,10,10,10,
				10,15,25,30,25,20,15,10,10,10,10,10,10,10,10,10,10,10,10,10};

TEXTMETRIC m_tm;

dc.GetTextMetrics(m_tm); // pobieramy parametry aktualnie wybranej czcionki

// jaka jest wysoko czcionki w pikslach:
int h=m_tm.tmAscent+  // ilo piksli od lini bazowej "w gr"
		m_tm.tmDescent; // ilo piksli od lini bazowej "w d"

		// konstruujemy prostokt obcinajcy obszar pisania tekstu
TRect  m_r(cx/20-20,3*cy/20-h,5*cx/8,3*cy/20+2*h);

char *str="Demonstracja funkcji ExtTextOut";

dc.SetBkColor(TColor::LtYellow); 	// kolor ta
dc.SetTextColor(TColor::LtRed); 		// kolor tekstu

dc.ExtTextOut(cx/20,3*cy/20,ETO_CLIPPED|ETO_OPAQUE,&m_r,str,-1,m_dx);
}
// ------------------------------------------------------------------------
void MojeOkno::CmTabbedTextOut()
// TabbedTextOut(const TPoint& p, const char far* string, int count,
// int numPositions, const int far* positions, int tabOrigin)
// Wykrela w punkcie p={x,y} a do 'count' znakw ze
// wskanika 'string\0'. Jeli count=-1, to wypisywany jest cay tekst
// numPositions=ilo pozycji tabulacji
// positions = wielkoci skoku tabulacji (narastajce)
// tabOrigin = pozycja startowa tabulatora
{
TClientDC dc(*this);
TPoint gdzie(10,5*cy/20);

TEXTMETRIC m_tm;
dc.GetTextMetrics(m_tm); // pobieramy parametry aktualnie wybranej czcionki
// jaka jest szeroko najszerszego znaku w aktualnie wybranej czcionce?
int szer=m_tm.tmMaxCharWidth;

char *str={"<-Oto\t|demonstracja uycia\t|funkcji\t|TabbedTextOuT->"};

int aTabs[3] = {5*szer,10*szer,15*szer};

dc.TabbedTextOut(gdzie,str,strlen(str),3,aTabs,0);

}
// ------------------------------------------------------------------------
void MojeOkno::CmDrawText()
// DrawText(const char far* string, int count, const TRect& r, uint16 format = 0);
// wywietla i formatuje 'string' w prostokcie 'r' a do 'count' znakw.
// Jeli count=-1, rto wywietlany jest cay tekst.
// format = kombinacja poniszych staych (lista nie jest kompletna):
// DT_BOTTOM	- wyrwnanie od dou. Musi by uyty wraz z DT_SINGLELINE
// DT_EXPANDTABS - "rozwi" znaki tabulacji (1 tab = 8 znakw)
// DT_CENTER	- centruj tekst horyzontalnie
// DT_LEFT - wyrwnaj tekst do lewej
// DT_RIGHT - wyrwnaj tekst do prawej
// DT_SINGLELINE - tekst jest pojedyncz lini i '\n' lub '\r' nie maj na wpywu
// DT_TOP - wyrwnanie od gry
// DT_VCENTER - centruj pionowo (tylko dla linii pojedynczej).
// DT_WORDBREAK - dziel i przeno zdanie na sowa jeli nie mieci si
//                Uwaga: \n rwnie "amie" lini!
{
TClientDC dc(*this);

TRect  m_r(10,6*cy/20,cx/3,9*cy/20);

dc.Rectangle(m_r);
dc.DrawText("Demonstracja funkcji DrawText",-1,m_r,DT_WORDBREAK);
dc.TextOut(10,10*cy/20,"(Jest narysowane okno clippingu)");
}
// ------------------------------------------------------------------------
void MojeOkno::CmGrayString()
// GrayString(const TBrush& brush, GRAYSTRINGPROC outputFunc, const char far* string, int count, const TRect& r);
// Wykrela "poszarzony" 'string' w prostokcie 'r'
// uywajc biecego pdzla i czcionki
{
TClientDC dc(*this);
TBrush pedzel=TBrush(TColor::LtRed);
TRect  m_r(10,12*cy/20,cx/2,14*cy/20);
dc.Rectangle(m_r);
dc.GrayString(pedzel,NULL,"Demonstracja funkcji GrayString",-1,m_r);
dc.TextOut(10,15*cy/20,"(uwaga j.w.)");
}
// ------------------------------------------------------------------------
class MojaAplikacja : public TApplication
{
public:
  MojaAplikacja() : TApplication() {}
  void InitMainWindow();
};
// ------------------------------------------------------------------------
void MojaAplikacja::InitMainWindow()
{
SetMainWindow(new MojeOkno("Pisanie tekstw w oknie Windows"));
MainWindow->AssignMenu("MAIN");
MainWindow->SetIcon(this, "IKONA1");
}
// ------------------------------------------------------------------------
OwlMain(int argc, char *argv[])
{
return MojaAplikacja().Run();
}
// ------------------------------------------------------------------------


