#include <owl\owlpch.h>
#include <owl\opensave.h>
#include "otwplik\otwplik.h"

// ---------------------------------------------------------------------
class MojeOkno : public TFrameWindow
{
private:
  TOpenSaveDialog::TData *dane_pliku;
  char nazwa_pliku[12];
public:
  MojeOkno(char * title);
  ~MojeOkno() {delete dane_pliku;}
  void CmPlikOtworz();
  void CmPlikKoniec();
  void SetupWindow();
  void Paint (TDC& dc, BOOL, TRect&);
DECLARE_RESPONSE_TABLE (MojeOkno);
};
// ---------------------------------------------------------------------
class MojaAplikacja : public TApplication
{
public:
	 MojaAplikacja();
	 void InitMainWindow();
	 void TytulOkna(LPSTR lpFileName);
};
// ---------------------------------------------------------------------
DEFINE_RESPONSE_TABLE1 (MojeOkno, TFrameWindow)
  EV_COMMAND(CM_PLIKOTWORZ, CmPlikOtworz),
  EV_COMMAND(CM_PLIKKONIEC, CmPlikKoniec),
END_RESPONSE_TABLE;
// ---------------------------------------------------------------------
MojeOkno::MojeOkno(char * title) : TFrameWindow(0, title)
{
}
// ---------------------------------------------------------------------
void MojeOkno::CmPlikOtworz()
{
// tworzymy obiekt TFileOpenDialog...
TFileOpenDialog f(this, *dane_pliku);
// ... i wywietlamy go
int res = f.Execute();
if (res == IDOK)
  {
  // uytkownika  klikn w OK, pobieramy wwczas nazw wybranego myszk pliku:
  f.GetFileTitle(dane_pliku->FileName, nazwa_pliku, 12);
  // umieszczamy nazw pliku na belce tytuowej okna aplikacji:
  ((MojaAplikacja *)GetApplication())->TytulOkna(nazwa_pliku);
  // wymyszamy komunikat WM_PAINT w celu "przemalowania" okna:
	Invalidate();
  }
  else
		MessageBox ("Operacja zostaa anulowana!", "Informacja");
}
// ---------------------------------------------------------------------
void MojeOkno::CmPlikKoniec()
{
CloseWindow(0);
}
// ---------------------------------------------------------------------
void MojeOkno::SetupWindow()
{
TFrameWindow::SetupWindow();
// inicjacja struktur danych niezbdnych do obsugi obiektu TFileOpenDialog
dane_pliku = new TOpenSaveDialog::TData
                         (
								 OFN_FILEMUSTEXIST,              // flagi
								 "Bazy danych (*.adr)|*.adr|"    // Filtry
								 "Wszystkie pliki (*.*)|*.*|",
								 0,      								// filtre uytkownika
								 "",     								// katalog domylny
								 "adr"); 								// rozszerzenie domylne

}
// ---------------------------------------------------------------------
void MojeOkno::Paint (TDC& dc, BOOL, TRect&)
{
char buf[256];
wsprintf (buf, "Pena nazwa pliku:%s", dane_pliku->FileName);
dc.TextOut(50,50,buf);
}
// ---------------------------------------------------------------------
MojaAplikacja::MojaAplikacja() : TApplication()
{
}
// ---------------------------------------------------------------------
void MojaAplikacja::InitMainWindow()
{
SetMainWindow(new MojeOkno("Ksika adresowa. adna baza danych nie jest otwarta!"));
MainWindow->AssignMenu("MAIN");
MainWindow->SetIcon(this,"IKONA1");
}
// ---------------------------------------------------------------------
void MojaAplikacja::TytulOkna(LPSTR nazwa_pliku)
{
char buf[256];
wsprintf (buf, "Ksika adresowa. Otwarty plik bazy danych:%s",nazwa_pliku);
MainWindow->SetCaption(buf);
}
// ---------------------------------------------------------------------
OwlMain(int, char **)
{
return MojaAplikacja().Run();
}
// ---------------------------------------------------------------------
