// ------------------------------------------------------------------------
// GRAFIKA.CPP  Pisanie i rysowanie w oknie Windows
//
#include <owl\owlpch.h>
#include  "grafika\grafika.h"

// ------------------------------------------------------------------------

// ------------------------------------------------------------------------
class MojeOkno : public TFrameWindow // Okno gwne programu
{
public:
	MojeOkno(char * title);
	~MojeOkno()
	  {
	  delete ptr_pedzel;
	  }
	void EvInitMenu(HMENU); // ustawienie menu
	bool CanClose();			// wyjcie z programu za potwierdzeniem
	void CmPlikKoniec()
	 {
	 CloseWindow(0);
	 }
	void CmMonitorColor()
	 {
	 monitor_color=TRUE;
	 }
	void CmMonitorMono()
	 {
	 monitor_color=FALSE;
	 }
	void Paint(TDC&, BOOL, TRect&);
private:
	TBrush *ptr_pedzel; 				// kolor biecego pdzla
	BOOL	monitor_color;				// czy monitor jest kolorowy?
	enum{EKRAN1,EKRAN2} typ_ekr;  //	dwa style przemalowywania obszaru
											// roboczego
  DECLARE_RESPONSE_TABLE(MojeOkno);
};
// ------------------------------------------------------------------------
DEFINE_RESPONSE_TABLE1(MojeOkno, TFrameWindow)
  EV_WM_INITMENU,               				// patrz metoda EvInitMenu
  EV_COMMAND(CM_PLIKKONIEC,    CmPlikKoniec),
  EV_COMMAND(CM_MONITOR_COLOR, CmMonitorColor),
  EV_COMMAND(CM_MONITOR_MONO,  CmMonitorMono),
  END_RESPONSE_TABLE;

void MojeOkno::EvInitMenu(HMENU menu)
// Uwaga: nazwa metody EvInitMenu jest na stae przypisana do
// komunikatu EV_WM_INITMENU
// Metoda sprawdza typ monitora (zmienn prywatn klasy, nic wicej!)
// i w zalenoci od niego stawia/lub nie parafk na odpowiednich
// pozycjach w menu Opcje
{
if(monitor_color==TRUE)
	 {
	 ::CheckMenuItem(menu, CM_MONITOR_COLOR, MF_CHECKED);
	 ::CheckMenuItem(menu, CM_MONITOR_MONO,  MF_UNCHECKED);
	 }
else
	 {
	 ::CheckMenuItem(menu, CM_MONITOR_COLOR, MF_UNCHECKED);
	 ::CheckMenuItem(menu, CM_MONITOR_MONO,  MF_CHECKED);
	 }
}

MojeOkno::MojeOkno(char * title) : TFrameWindow(0, title)
{
ptr_pedzel =new TBrush(TColor::LtBlue);
typ_ekr=EKRAN1;
monitor_color=TRUE;
}
// ------------------------------------------------------------------------
bool MojeOkno::CanClose()
{
return MessageBox("Czy chcesz zakoczy prac programu?", "Koniec pracy programu",
						  MB_YESNO | MB_ICONQUESTION) == IDYES;
}


// ------------------------------------------------------------------------
void MojeOkno::Paint(TDC& dc, BOOL, TRect&)
// rysuje ponownie obszar roboczy, ktry uleg "uszkodzeniu" w wyniku
// zmiany rozmiaru okna (powikszenie).
// Metoda jest automatycznie wywoywana w wyniku komunikatu WM_PAINT
// dc : display context
// TRect& : prostokt wymagajcy "przemalowania"
{
if(typ_ekr==EKRAN1)
  typ_ekr=EKRAN2;
else
typ_ekr=EKRAN1;

if(monitor_color==TRUE)
 switch(typ_ekr)
	{
	case EKRAN1:
		 delete ptr_pedzel; // usuwamy stary pdzel
		 ptr_pedzel =new TBrush(TColor::LtRed);
		 break;
	case EKRAN2:
		 delete ptr_pedzel; // usuwamy stary pdzel
		 ptr_pedzel =new TBrush(TColor::LtBlue);
		 break;
	 }
else
 switch(typ_ekr)
	{
	case EKRAN1:
		 delete ptr_pedzel; // usuwamy stary pdzel
		 ptr_pedzel =new TBrush(TColor::Black, HS_BDIAGONAL);
		 break;
	case EKRAN2:
		 delete ptr_pedzel; // usuwamy stary pdzel
		 ptr_pedzel =new TBrush(TColor::Black, HS_CROSS);
		 break;
	 }
// wybr obszaru roboczego
TRect trClient = GetClientRect();
// wybr pdzla
dc.SelectObject(*ptr_pedzel);
// wypeniamy obszar roboczy okrelonym "kolorem"
dc.PatBlt(0,0,trClient.right,trClient.bottom,PATCOPY);
dc.TextOut(140,200," ZMIE ROZMIARY OKNA! ");
dc.DrawFocusRect(20,10,190,195);
dc.TextOut(200,10," <---- prostokt ");
dc.Arc(10,10,250,350,20,20,200,300);
dc.TextOut(220,300," <---- uk ");
}
// ------------------------------------------------------------------------
class MojaAplikacja : public TApplication
{
public:
  MojaAplikacja() : TApplication() {}
  void InitMainWindow();
};

void MojaAplikacja::InitMainWindow()
{
SetMainWindow(new MojeOkno("Demonstracja odwieania zawartoci okna"));
MainWindow->AssignMenu("MAIN");
MainWindow->SetIcon(this, "IKONA1");
}
// ------------------------------------------------------------------------
OwlMain(int argc, char *argv[])
{
return MojaAplikacja().Run();
}


