// ------------------------------------------------------------------------
// FUNGR32.CPP  Program testuje niektre funkcje graficzne
//              wystpujce wyycznie w wersji 32 bit
//
#include <owl\owlpch.h>
#include <math.h>
#include "fungr32\fungr32.h"
// ------------------------------------------------------------------------
class MojeOkno : public TFrameWindow // Okno gwne programu
{
public:
	MojeOkno(char * title);
	~MojeOkno(){}
	void CmPolyBezier();
	void CmDrawPath();
	void CmStrokePath();

	void Paint(TDC&, BOOL, TRect&);
	void EvSize(uint sizeType, TSize& size);
	void CmPlikKoniec(){CloseWindow(0);}
private:
	int cx,cy;							// rozmiary obszaru roboczego
	int wybrano;						// figura na ekranie
	void PolyBezier();
	void DrawPath();
	void StrokePath();

  DECLARE_RESPONSE_TABLE(MojeOkno);
};
// ------------------------------------------------------------------------
DEFINE_RESPONSE_TABLE1(MojeOkno, TFrameWindow)
  EV_WM_SIZE,      // patrz metoda EvSize
  EV_COMMAND(CM_PLIKKONIEC,    CmPlikKoniec),
  EV_COMMAND(CM_POLYBEZIER,    CmPolyBezier),
  EV_COMMAND(CM_DRAWPATH,      CmDrawPath),
  EV_COMMAND(CM_STROKEPATH,    CmStrokePath),
  END_RESPONSE_TABLE;
// ------------------------------------------------------------------------
MojeOkno::MojeOkno(char * title) : TFrameWindow(0, title)
{
wybrano=1; // krzywe Bezier
}
// ------------------------------------------------------------------------
void MojeOkno::EvSize(uint sizeType, TSize& size)
{
Invalidate(); 	// zmuszamy system do narysowania jeszcze raz
					// okna po zmianie jego rozmiaru
}
// ------------------------------------------------------------------------
void MojeOkno::Paint(TDC&, BOOL, TRect&)
{
switch(wybrano)
  {
  case 1 : PolyBezier(); break;
  case 2 : DrawPath();   break;
  case 3 : StrokePath(); break;
  }
}
// ------------------------------------------------------------------------
void MojeOkno::CmPolyBezier()
{
wybrano = 1;
Invalidate();
}
// ------------------------------------------------------------------------
void MojeOkno::CmDrawPath()
{
wybrano = 2;
Invalidate();
}
// ------------------------------------------------------------------------
void MojeOkno::CmStrokePath()
{
wybrano = 3;
Invalidate();
}

// ------------------------------------------------------------------------
// Metody prywatne
void MojeOkno::PolyBezier() // tylko dla platform 32-bitowych!
{
char buf[100];
TPoint defB[4];  // 4 punkty kontrolne dla krzywej Bezier

TClientDC dc(*this);
TRect trClient = GetClientRect(); // wybr obszaru roboczego
cx=trClient.Width();
cy=trClient.Height();

// Krzywa Bezier bdzie w miar losowa...
dc.TextOut(10,0,"Punkty kontrolne (1,2,3,4) i efekt funkcji PolyBezier (1,4)");
for(int i=0;i<4;i++)
  {
  defB[i].x=random(cx);
  defB[i].y=random(cy);
  wsprintf(buf,"%d.",i+1);
  dc.TextOut(defB[i].x,defB[i].y,buf);
  }

dc.MoveTo(defB[0].x,defB[0].y);
dc.LineTo(defB[1].x,defB[1].y);

dc.MoveTo(defB[2].x,defB[2].y);
dc.LineTo(defB[3].x,defB[3].y);

dc.PolyBezier(defB,4);
}
// ------------------------------------------------------------------------
void MojeOkno::DrawPath()
// Rysujemy w sposb klasyczny losow krzyw zoon z
// 10 odcinkw, po wykreleniu kadego system wstrzymuje
// wykonanie programu na 1s, ale kady fragment rysowanej
// krzywej jest widoczny
{
TClientDC dc(*this);
TRect trClient = GetClientRect(); // wybr obszaru roboczego
cx=trClient.Width();
cy=trClient.Height();
dc.TextOut(10,0,"Czekaj cierpliwie...");
dc.MoveTo(10,10);
for(int i=0;i<10;i++)
  {
  sleep(1); // czekamy 1 sekund
  dc.LineTo(random(cx),random(cy));
  }
}
// ------------------------------------------------------------------------
void MojeOkno::StrokePath()  // tylko dla platform 32-bitowych!
{
// Konstruujemy losow krzyw zoon z 10 odcinkw.
// Jest ona konstruowana poczwszy od BeginPath do EndPath i
// wywietlana na samo koniec, jako jeden obiekt graficznm
TClientDC dc(*this);
TRect trClient = GetClientRect(); // wybr obszaru roboczego
cx=trClient.Width();
cy=trClient.Height();
dc.TextOut(10,0,"Demonstracja funkcji StrokePath, CZEKAJ CIERPLIWIE!");
dc.BeginPath(); // pocztek zapamitywania cieki
dc.MoveTo(10,10);
for(int i=0;i<10;i++)
  {
  sleep(1); // czekamy 1 sekund
  dc.LineTo(random(cx),random(cy));
  }
dc.EndPath(); // koniec zapamitywania cieki
dc.StrokePath();
}
// ------------------------------------------------------------------------

// ------------------------------------------------------------------------
class MojaAplikacja : public TApplication
{
public:
  MojaAplikacja() : TApplication() {}
  void InitMainWindow();
};
// ------------------------------------------------------------------------
void MojaAplikacja::InitMainWindow()
{
SetMainWindow(new MojeOkno("Funkcje graficzne OWL/GDI 32 bit"));
MainWindow->AssignMenu("MAIN");
MainWindow->SetIcon(this, "IKONA1");
}
// ------------------------------------------------------------------------
OwlMain(int argc, char *argv[])
{
return MojaAplikacja().Run();
}
// ------------------------------------------------------------------------


