// ------------------------------------------------------------------------
// FUNGR16.CPP  Program testuje niektre funkcje graficzne
//              wystpujce w wersji 16 i 32 bit
//
#include <owl\owlpch.h>
#include <math.h>
#include  "fungr16\fungr16.h"
// ------------------------------------------------------------------------
class MojeOkno : public TFrameWindow // Okno gwne programu
{
public:
	MojeOkno(char * title);
	~MojeOkno(){}
	void CmAngleArc();
	void CmArc();
	void Paint(TDC&, BOOL, TRect&);
	void EvSize(uint sizeType, TSize& size);
	void CmPlikKoniec(){CloseWindow(0);}
private:
	int cx,cy;							// rozmiary obszaru roboczego
	int wybrano;						// figura na ekranie
  DECLARE_RESPONSE_TABLE(MojeOkno);
};
// ------------------------------------------------------------------------
DEFINE_RESPONSE_TABLE1(MojeOkno, TFrameWindow)
  EV_WM_SIZE,      // patrz metoda EvSize
  EV_COMMAND(CM_PLIKKONIEC,    CmPlikKoniec),
  EV_COMMAND(CM_ARC,           CmArc),
  END_RESPONSE_TABLE;
// ------------------------------------------------------------------------
MojeOkno::MojeOkno(char * title) : TFrameWindow(0, title)
{
}
// ------------------------------------------------------------------------
void MojeOkno::EvSize(uint sizeType, TSize& size)
{
Invalidate(); 	// zmuszamy system do narysowania jeszcze raz
					// okna po zmianie jego rozmiaru
}
// ------------------------------------------------------------------------
void MojeOkno::Paint(TDC&, BOOL, TRect&)
{
CmArc();
}
// ------------------------------------------------------------------------
void MojeOkno::CmArc()
{
TClientDC dc(*this);
TRect trClient = GetClientRect(); // wybr obszaru roboczego
cx=trClient.Width();
cy=trClient.Height();
dc.TextOut(cx/6,20," Demonstracja funkcji Arc(x1,y1, x2,y2, x3,y3, x4,y4)");

dc.TextOut(1,45,"x1,y1");
dc.TextOut(cx-70,cy-40,"x2,y2");

dc.TextOut(20,0,"x4,y4");
dc.TextOut(cx-40,cy-90,"x3,y3");

dc.MoveTo(50,50);
dc.LineTo(cx-50,50);
dc.LineTo(cx-50,cy-50);
dc.LineTo(50,cy-50);
dc.LineTo(50,50);

dc.MoveTo(cx/2,cy/2); dc.LineTo(10,10);
dc.MoveTo(cx/2,cy/2); dc.LineTo(cx-10,cy-100);

dc.Arc(50,50, cx-50,cy-50, // obszar otaczajcy uk (tutaj niecay o. roboczy))
		 cx-10,cy-100,        // punkt startowy uku
		 10,10);             // punkt kocowy uku
}
// ------------------------------------------------------------------------
class MojaAplikacja : public TApplication
{
public:
  MojaAplikacja() : TApplication() {}
  void InitMainWindow();
};
// ------------------------------------------------------------------------
void MojaAplikacja::InitMainWindow()
{
SetMainWindow(new MojeOkno("Funkcje graficzne OWL/GDI 16 bit"));
MainWindow->AssignMenu("MAIN");
MainWindow->SetIcon(this, "IKONA1");
}
// ------------------------------------------------------------------------
OwlMain(int argc, char *argv[])
{
return MojaAplikacja().Run();
}
// ------------------------------------------------------------------------


