#include <owl\owlpch.h>
#include "druk2\druk2.h"

enum {GDI,MENEDZER_WYDRUKU}kto=GDI;

class MojeOkno : public TFrameWindow
{
private:
	 TPrinter* drukarka;
	int cx,cy;							// rozmiary obszaru roboczego
public:
	 MojeOkno(char * title);
	 ~MojeOkno();
	 void EvSize(uint sizeType, TSize& size);
	 void CmPlikDrukuj();
	 void CmUstawieniaWydruku();
	 void CmPlikKoniec(){CloseWindow(0);}
 DECLARE_RESPONSE_TABLE(MojeOkno);
};
DEFINE_RESPONSE_TABLE1(MojeOkno, TFrameWindow)
  EV_WM_SIZE,
  EV_COMMAND(CM_PLIKDRUKUJ, CmPlikDrukuj),
  EV_COMMAND(CM_PLIKPSETUP, CmUstawieniaWydruku),
  EV_COMMAND(CM_PLIKKONIEC,    CmPlikKoniec),

END_RESPONSE_TABLE;
// ----------------------------------------------------------------------------
class DokumentPrn : public TPrintout
{
public:
 DokumentPrn(const char* title, TWindow* okno);
 void GetDialogInfo(int& minPage, int& maxPage,int& selFromPage, int& selToPage);
 void PrintPage(int page, TRect& rect, unsigned flags);
 void TrybDruku(BOOL b) {Banding = b;}
 BOOL HasPage(int pageNumber)
		{
		return pageNumber == 1;
		}
protected:
 TWindow* Okno;
};
// ----------------------------------------------------------------------------
DokumentPrn::DokumentPrn(const char* title, TWindow* okno):TPrintout(title)
{
Okno = okno;
}
// ----------------------------------------------------------------------------
void DokumentPrn::PrintPage(int, TRect& rect, unsigned)
// test odczytu parametrw z drajwera drukarki
{
TPrintDC& dc = *DC;
TSize     pageSize = PageSize;

int szer_prn=dc.GetDeviceCaps(HORZRES);    // mj rezultat: 2368 jednostek logicznych
int wys_prn=dc.GetDeviceCaps(VERTRES);     // mj rezultat: 3200 jednostek logicznych

int szer=szer_prn/100; // ok. 100 znakw  na szeroko strony
int wys=wys_prn/120;  // ok. 120 wierszy na dugo   strony

LOGFONT lf;
memset(&lf,0,sizeof(LOGFONT));    // wane!
strcpy(lf.lfFaceName,"Times New Roman CE");
		 lf.lfHeight=wys;
		 lf.lfWidth =szer;
		 lf.lfUnderline=0;
		 lf.lfItalic=1;
		 lf.lfStrikeOut=0;
		 lf.lfCharSet=DEFAULT_CHARSET; // w zasadzie gwarantuje polskie znaki
		 lf.lfQuality=DRAFT_QUALITY;   // DEFAULT_QUALITY, PROOF_QUALITY

TFont *ptfont=new TFont(&lf);
dc.SelectObject(*ptfont);
// rysujemy prostokt wielkoci prawie caej strony
TRect otoczka(10*szer,5*wys, szer_prn-10*szer, wys_prn-5*wys);
dc.Rectangle(otoczka);
// opisujemy naroniki
dc.TextOut(15*szer,           8*wys, "lewy grny rg");
dc.TextOut(szer_prn-30*szer,  8*wys, "prawy grny rg");

dc.TextOut(15*szer,           wys_prn-8*wys,"lewy dolny rg");
dc.TextOut(szer_prn-30*szer , wys_prn-8*wys,"prawy dolny rg");

dc.RestoreObjects();
}


// ----------------------------------------------------------------------------
void DokumentPrn::GetDialogInfo(int& minPage, int& maxPage,
										 int& selFromPage, int& selToPage)
{
// jeli dokument ma tylko jedn stron stron, to nie nalezy
// uaktywnia opcji "zakres stron"
minPage = maxPage = 0;
selFromPage = selToPage = 0;
}
//----------------------------------------------------------------------------
MojeOkno::MojeOkno(char * title) : TFrameWindow(0, title)
{
drukarka = new TPrinter;
}
//----------------------------------------------------------------------------
MojeOkno::~MojeOkno()
{
delete drukarka;
}
//----------------------------------------------------------------------------
void MojeOkno::EvSize(uint sizeType, TSize& size)
// zarejestruj zmienione parametry okna
{
TRect trClient = GetClientRect(); // wybr obszaru roboczego
cx=trClient.Width();
cy=trClient.Height();
}
//----------------------------------------------------------------------------
void MojeOkno::CmPlikDrukuj()
{
if(drukarka)
  {
  DokumentPrn printout("Test druku", this);
  printout.TrybDruku(TRUE);
  drukarka->Print(this, printout, TRUE);
  }
}
//----------------------------------------------------------------------------
void MojeOkno::CmUstawieniaWydruku()
{
if (drukarka)
  drukarka->Setup(this);
}
// ----------------------------------------------------------------------------
//----------------------------------------------------------------------------
class MojaAplikacja : public TApplication
{
 public:
 MojaAplikacja() : TApplication() {}
 void InitMainWindow()
	  {
	  SetMainWindow(new MojeOkno("Drukowanie dokumentw z OWL"));
	  MainWindow->AssignMenu("MAIN");
	  MainWindow->SetIcon(this, "IKONA1");
	 }
};
//----------------------------------------------------------------------------
int OwlMain(int, char**)
{
MojaAplikacja app;
// app.nCmdShow=SW_MINIMIZE;
if(app.hPrevInstance)
	return 0;
else
	return app.Run();
}
//----------------------------------------------------------------------------

