// ------------------------------------------------------------------------
// WYKRES.CPP  Program rysujcy wykres funkcji w oknie
//
#include <owl\owlpch.h>
#include <math.h>
#include  "wykres\wykres.h"
// ------------------------------------------------------------------------
class MojeOkno : public TFrameWindow // Okno gwne programu
{
public:
	MojeOkno(char * title);
	~MojeOkno(){}
	void CmWykres();
	void EvSize(uint sizeType, TSize& size);
	void CmPlikKoniec()
	 {
	 CloseWindow(0);
	 }
	void Paint(TDC&, BOOL, TRect&) {CmWykres();}
private:
	int cx,cy;							// rozmiary obszaru roboczego
  DECLARE_RESPONSE_TABLE(MojeOkno);
};
// ------------------------------------------------------------------------
DEFINE_RESPONSE_TABLE1(MojeOkno, TFrameWindow)
  EV_WM_SIZE,               					// patrz metoda EvSize
  EV_COMMAND(CM_PLIKKONIEC,    CmPlikKoniec),
  EV_COMMAND(CM_WYKRESSINUS,   CmWykres),
  END_RESPONSE_TABLE;
// ------------------------------------------------------------------------
MojeOkno::MojeOkno(char * title) : TFrameWindow(0, title)
{
}
// ------------------------------------------------------------------------
void MojeOkno::EvSize(uint sizeType, TSize& size)
{
Invalidate(); 	// zmuszamy system do narysowania jeszcze raz
		// okna po zmianie jego rozmiaru
}
// ------------------------------------------------------------------------
void MojeOkno::CmWykres()
{
// Uwaga : zadanie jest o tyle uproszczone, e znamy
// maksymaln warto przyjmowan przez funkcj sinus (tzn. 1)
// W przypadku innych funkcji naley t warto odnale i wg
// niej przeprowadzi dopasowanie wykresu do ekranu!
TClientDC dc(*this);
TRect trClient = GetClientRect();
cx=trClient.Width();
cy=trClient.Height();
dc.TextOut(cx/3,20," Wykres funkcji y=sin(x) ");
dc.MoveTo(0, cy/2); dc.LineTo(cx,cy/2); // linia rodkowa
for(int x=0;x<cx;x++)
  {
  double yplot,y=sin(x*2*3.14/(double)cx);
  yplot=(double )cy/2*y;
  dc.SetPixel(x,(double)cy/2-(int)yplot,TColor::Black);
  }
}
// ------------------------------------------------------------------------
class MojaAplikacja : public TApplication
{
public:
  MojaAplikacja() : TApplication() {}
  void InitMainWindow();
};
// ------------------------------------------------------------------------
void MojaAplikacja::InitMainWindow()
{
SetMainWindow(new MojeOkno("Wykresy funkcji"));
MainWindow->AssignMenu("MAIN");
MainWindow->SetIcon(this, "IKONA1");
}
// ------------------------------------------------------------------------
OwlMain(int argc, char *argv[])
{
return MojaAplikacja().Run();
}
// ------------------------------------------------------------------------


