#include <owl\owlpch.h>
#include "pobdane/pobdane.h"
#include "pobdane/formosob.h"
#include <owl/inputdia.h>

// ----------------------------------------------------------------------
class FormularzOsobowy; // deklaracja wyprzedzajca

// okno gwne
class MojeOkno : public TFrameWindow
{
public:
	 MojeOkno(char * title);
	 void CmPlikKoniec();
	 void CmEdycjaPredef();
	 void CmEdycjaNieBlokujaca();
	 void CmEdycjaBlokujaca();
	 void CmNaTematProgramu();
	 LRESULT CmUaktualnijBazeDanych (WPARAM wParam, LPARAM lParam);
  private:
	 FormularzOsobowy * ptr_form1;
	 int uprawnienia;
  DECLARE_RESPONSE_TABLE (MojeOkno);
};

DEFINE_RESPONSE_TABLE1 (FormularzOsobowy, TDialog)
  EV_CHILD_NOTIFY_ALL_CODES(IDB_WPROWADZ, FormWprowadz),
  EV_CHILD_NOTIFY_ALL_CODES(IDB_ANULUJ, FormAnuluj),
  EV_CHILD_NOTIFY_ALL_CODES(IDC_NAZWISKO, FormEdycja),
END_RESPONSE_TABLE;
// ----------------------------------------------------------------------

FormularzOsobowy::FormularzOsobowy(MojeOkno *okno_glowne, TResId resId):TDialog(okno_glowne,resId)
{
// zasadniczym celem jest tutaj wywoanie konstruktora klasy bazowej...
}
// ----------------------------------------------------------------------
void FormularzOsobowy::SetupWindow()
{
TDialog::SetupWindow();
// dezaktywacja przycisku 'Wprowad' (bufor jest pusty na pocztku)
HWND p = GetDlgItem(IDB_WPROWADZ);
::EnableWindow(p, FALSE);
}
// ----------------------------------------------------------------------
void FormularzOsobowy::FormWprowadz(UINT notify)
{
// kopiujemy do globalnego bufora dane z okienka
char buf[MAXLEN/4];
GetDlgItemText (IDC_IMIE, osoba_dbd.imie,MAXLEN);
GetDlgItemText (IDC_NAZWISKO, osoba_dbd.nazwisko,MAXLEN);
GetDlgItemText (IDC_FUNKCJA, osoba_dbd.funkcja,MAXLEN);
GetDlgItemText (IDC_WIEK, buf,MAXLEN);
osoba_dbd.wiek=atoi(buf);
// informujemy o tym okno gwne programu
Parent->HandleMessage(M_WPROWADZONODANE, 0, 0L);
}
// ----------------------------------------------------------------------
void FormularzOsobowy::FormAnuluj(UINT notify)
{
MessageBox ("Dane nie zostay zmienione!", MB_OK);
this->Destroy();
}
// ----------------------------------------------------------------------

void FormularzOsobowy::FormEdycja(UINT notify)
{
if (notify==EN_CHANGE) // nastpia jaka zmiana w polu edycyjnym 'nazwisko'
 {
 HWND hwndImie = GetDlgItem (IDC_NAZWISKO);
 // pobiera dugo w bajtach okienka tekstowego:
 int n = (::GetWindowTextLength(hwndImie));
 HWND hwndWprowadz = GetDlgItem (IDB_WPROWADZ);
 if(n!=0) // uaktywnia przycisk jeli pole edycji co zawiera
			::EnableWindow(hwndWprowadz,TRUE);
 }
}
// ----------------------------------------------------------------------
DEFINE_RESPONSE_TABLE1 (MojeOkno, TFrameWindow)
  EV_MESSAGE(M_WPROWADZONODANE, CmUaktualnijBazeDanych),
  EV_COMMAND(CM_PLIKKONIEC, CmPlikKoniec),
  EV_COMMAND(CM_EDYCJAPREDEF, CmEdycjaPredef),
  EV_COMMAND(CM_EDYCJANBL, CmEdycjaNieBlokujaca),
  EV_COMMAND(CM_EDYCJABL, CmEdycjaBlokujaca),
  EV_COMMAND(CM_NATEMATPROGRAMU, CmNaTematProgramu),
END_RESPONSE_TABLE;
// ----------------------------------------------------------------------
MojeOkno::MojeOkno(char * title) : TFrameWindow(0, title)
{
ptr_form1 = 0;
}
// ----------------------------------------------------------------------
void MojeOkno::CmPlikKoniec()
{
CloseWindow(0);
}
// ----------------------------------------------------------------------
void MojeOkno::CmEdycjaPredef()
// TInputDialog(TWindow* parent,const char far *title, const char far *prompt,
//              char far* buffer,int buffersize)
{
char str[10]={""};
int n=1;
if ((TInputDialog(this,"Poziom uprawnie",
							  "Podaj nowy poziom uprawnie uytkownika:",
							  str,10)).Execute()==IDOK)
uprawnienia=atoi(str);// zamy, e ta warto jest pniej w jaki sposb
								 // wykorzystywana
}

// ----------------------------------------------------------------------
void MojeOkno::CmEdycjaNieBlokujaca()
{
		 // jeli okienko istniej, to tylko je uaktywniamy
if (ptr_form1 && ptr_form1->IsWindow())
		  ptr_form1->SetActiveWindow();
else // w przeciwnym przypadku musimy je dopiero utworzy
	 {
	 ptr_form1 = new FormularzOsobowy (this, FORM_OSOBA);
	 ptr_form1->Create(); // tworzy okienko amodalne
	 }
}
// ----------------------------------------------------------------------
// tworzymy okienko modalne (blokujce operacje na innych oknach)
void MojeOkno::CmEdycjaBlokujaca()
{
ptr_form1 = new FormularzOsobowy (this, FORM_OSOBA);
ptr_form1->Execute(); // tworzy okienko modalne
}
// ----------------------------------------------------------------------
void MojeOkno::CmNaTematProgramu()
{
TDialog(this, IDD_NATEMAT).Execute();
}
// ----------------------------------------------------------------------
LRESULT MojeOkno::CmUaktualnijBazeDanych(WPARAM, LPARAM)
{
char buf[200];
wsprintf(buf,"[%s %s,funkcja:%s,wiek:%d]",osoba_dbd.imie,osoba_dbd.nazwisko,osoba_dbd.funkcja,osoba_dbd.wiek);
MessageBox (buf, "Dane zostay wprowadzone do bazy!", MB_OK);
return 0L;
}
// ----------------------------------------------------------------------
class MojaAplikacja : public TApplication
{
public:
	 MojaAplikacja();
	 void InitMainWindow();
};
// ----------------------------------------------------------------------
MojaAplikacja::MojaAplikacja() : TApplication()
{
}
// ----------------------------------------------------------------------
void MojaAplikacja::InitMainWindow()
{
SetMainWindow (new MojeOkno("Formularze ekranowe i okienka dialogowe Windows/OWL"));
MainWindow->AssignMenu("MAIN");
MainWindow->SetIcon(this, "IKONA1");
}
// ----------------------------------------------------------------------
OwlMain(int, char **)
{
return MojaAplikacja().Run();
}

