#include "adresy\defs.h"  		// definicja klas
// -------------------------------------------------------------------------
// Handlery komunikatw dla klasy FormularzAdresowy
DEFINE_RESPONSE_TABLE1 (FormularzAdresowy, TDialog)
  EV_WM_DESTROY,
  EV_CHILD_NOTIFY_ALL_CODES(IDB_WPROWADZ, FormWprowadz),
  EV_CHILD_NOTIFY_ALL_CODES(IDB_ANULUJ, 	FormAnuluj),
  EV_CHILD_NOTIFY_ALL_CODES(IDC_NAZWISKO, FormEdycja),
END_RESPONSE_TABLE;
// =========================================================================
// realizacja metod dla klasy FormularzAdresowy
void FormularzAdresowy::SetupWindow()
{
TDialog::SetupWindow();
// dezaktywacja przycisku 'Wprowad' (bufor jest pusty na pocztku)
HWND p = GetDlgItem(IDB_WPROWADZ);
::EnableWindow(p, FALSE);
if(poprawianie==true)
  { // przepisz dane z biecego rekordu do okienka dialogowego
  SetDlgItemText(IDC_IMIE, adr.bdd_imie);
  SetDlgItemText(IDC_NAZWISKO, adr.bdd_nazwisko);
  SetDlgItemText(IDC_ADRES, adr.bdd_adres);
  SetDlgItemText(IDC_MIASTO, adr.bdd_miasto);
  SetDlgItemText(IDC_TELEFON, adr.bdd_telefon);
  SetDlgItemText(IDC_FAX, adr.bdd_fax);
  }
}
// ----------------------------------------------------------------------
void FormularzAdresowy::FormWprowadz(UINT)
// Wprowadzamy nowe lub zmodyfikowane dane do bazy
{
adr.clear_buf();
GetDlgItemText(IDC_IMIE, adr.bdd_imie,MAXLEN);
GetDlgItemText(IDC_NAZWISKO, adr.bdd_nazwisko,MAXLEN);
GetDlgItemText(IDC_ADRES, adr.bdd_adres,MAXLEN);
GetDlgItemText(IDC_MIASTO, adr.bdd_miasto,MAXLEN);
GetDlgItemText(IDC_TELEFON, adr.bdd_telefon,MAXLEN);
GetDlgItemText(IDC_FAX, adr.bdd_fax,MAXLEN);
// informujemy okno gwne o wprowadzeniu danych do bufora
Parent->HandleMessage(M_WPROWADZONODANE, 0, 0L);
this->Destroy();
}
// ----------------------------------------------------------------------
void FormularzAdresowy::FormAnuluj(UINT)
{
MessageBox ("Dane nie zostay zmienione!", MB_OK);
this->Destroy();
}
// ----------------------------------------------------------------------
void FormularzAdresowy::FormEdycja(UINT notify)
{
if (notify==EN_CHANGE) // nastpia jaka zmiana w polu edycyjnym 'nazwisko'
 {
 HWND nazw = GetDlgItem (IDC_NAZWISKO);
 // pobiera dugo w bajtach okienka tekstowego:
 int n=(::GetWindowTextLength(nazw));
 HWND hwndWprowadz = GetDlgItem (IDB_WPROWADZ);
 if(n!=0) // uaktywnia przycisk jeli pole edycji co zawiera
			::EnableWindow(hwndWprowadz,TRUE);
 }
}
// ----------------------------------------------------------------------
void FormularzAdresowy::EvDestroy()
{
TDialog::EvDestroy();
}
// ----------------------------------------------------------------------
FormularzAdresowy::FormularzAdresowy(MojeOkno *okno_glowne, TResId resId):TDialog(okno_glowne,resId)
{
// zasadniczym celem jest tutaj wywoanie konstruktora klasy bazowej...
}
