//: Playground - noun: a place where people can play

import Cocoa

enum TextAlignment: Int {
    case Left    = 20
    case Right   = 30
    case Center  = 40
    case Justify = 50
}

var alignment = TextAlignment.Justify
print("Left ma wartość pierwotną \(TextAlignment.Left.rawValue)")
print("Right ma wartość pierwotną \(TextAlignment.Right.rawValue)")
print("Center ma wartość pierwotną \(TextAlignment.Center.rawValue)")
print("Justify ma wartość pierwotną \(TextAlignment.Justify.rawValue)")
print("Zmienna alignment ma wartość pierwotną \(alignment.rawValue)")

switch alignment {
case .Left:
    print("Wyrównanie do lewej")
    
case .Right:
    print("Wyrównanie do prawej")
    
case .Center:
    print("Wyśrodkowanie")
    
case .Justify:
    print("Wyjustowanie")
}

// Utworzenie wartości pierwotnej.
let myRawValue = 100

// Próba konwersji wartości pierwotnej na typ TextAlignment.
if let myAlignment = TextAlignment(rawValue: myRawValue) {
    // Konwersja zakończyła się sukcesem!
    print("Udało się skonwertować \(myRawValue) na typ TextAlignment.")
} else {
    // Konwersja zakończyła się niepowodzeniem.
    print("\(myRawValue) nie ma odpowiadającego jej bloku case w typie TextAlignment.")
}

enum ProgrammingLanguage: String {
    case Swift
    case ObjectiveC = "Objective-C"
    case C
    case Cpp        = "C++"
    case Java
}

let myFavoriteLanguage = ProgrammingLanguage.Swift
print("Moim ulubionym językiem programowania jest \(myFavoriteLanguage.rawValue).")

enum Lightbulb {
    case On
    case Off
    
    func surfaceTemperatureForAmbientTemperature(ambient: Double) -> Double {
        switch self {
        case .On:
            return ambient + 150.0
        case .Off:
            return ambient
        }
    }
    
    mutating func toggle() {
        switch self {
        case .On:
            self = .Off
        case .Off:
            self = .On
        }
    }
}
var bulb = Lightbulb.On
let ambientTemperature = 77.0

var bulbTemperature = bulb.surfaceTemperatureForAmbientTemperature(ambient: ambientTemperature)
print("Temperatura żarówki wynosi \(bulbTemperature).")

enum ShapeDimensions {
    // Punkt nie ma powiązanej z nim wartości, jest pozbawiony wymiarów.
    case Point
    
    // Wartość powiązana z kwadratem to długość jego boku.
    case Square(Double)
    
    // Wartości powiązane z prostokątem to szerokość i wysokość.
    case Rectangle(width: Double, height: Double)
    
    func area() -> Double {
        switch self {
        case .Point:
            return 0
            
        case let .Square(side):
            return side * side
            
        case let .Rectangle(width: w, height: h):
            return w * h
        }
    }
}

var squareShape = ShapeDimensions.Square(10.0)
var rectShape = ShapeDimensions.Rectangle(width: 5.0, height: 10.0)
var pointShape = ShapeDimensions.Point

print("Powierzchnia kwadratu = \(squareShape.area()).")
print("Powierzchnia prostokąta = \(rectShape.area()).")
print("Powierzchnia punktu = \(pointShape.area()).")

enum FamilyTree {
    case NoKnownParents
    indirect case OneKnownParent(name: String, ancestors: FamilyTree)
    indirect case TwoKnownParents(fatherName: String, fatherAncestors: FamilyTree,
        motherName: String, motherAncestors: FamilyTree)
}

let fredAncestors = FamilyTree.TwoKnownParents(
    fatherName: "Fred Senior",
    fatherAncestors: .OneKnownParent(name: "Beata", ancestors: .NoKnownParents),
    motherName: "Marta",
    motherAncestors: .NoKnownParents)
