//: Playground - noun: a place where people can play

import Cocoa

func printGreeting() {
    print("Witaj, playground!")
}
printGreeting()

func printPersonalGreetings(names: String...) {
    for name in names {
        print("\(name), witaj w pliku typu playground!")
    }
}
printPersonalGreetings(names: "Aleksy","Krzysztof","Dorota","Paulina")

func divisionDescription(forNumerator num: Double,
                         andDenominator den: Double,
                         withPunctuation punctuation: String = ".") -> String {
    return "\(num) dzielone przez \(den) daje \(num / den)\(punctuation)"
}
print(divisionDescription(forNumerator: 9.0,
                          andDenominator: 3.0,
                          withPunctuation: "!"))

var error = "Żądanie zakończyło się niepowodzeniem:"
func appendErrorCode(code: Int, toErrorString errorString: inout String) {
    if code == 400 {
        errorString += " nieprawidłowe żądanie."
    }
}
appendErrorCode(code: 400, toErrorString: &error)
error

func areaOfTriangle(withBase base: Double, andHeight height: Double) -> Double {
    let numerator = base * height
    func divide() -> Double {
        return numerator / 2
    }
    return divide()
}
areaOfTriangle(withBase: 3.0, andHeight: 5.0)

func sortEvenOdd(numbers: [Int]) -> (evens: [Int], odds: [Int]) {
    var evens = [Int]()
    var odds = [Int]()
    for number in numbers {
        if number % 2 == 0 {
            evens.append(number)
        } else {
            odds.append(number)
        }
    }
    return (evens, odds)
}
let aBunchOfNumbers = [10,1,4,3,57,43,84,27,156,111]
let theSortedNumbers = sortEvenOdd(numbers: aBunchOfNumbers)
print("Liczbami parzystymi są: \(theSortedNumbers.evens); liczbami nieparzystymi są: \(theSortedNumbers.odds)")

func grabMiddleName(name: (String, String?, String)) -> String? {
    return name.1
}

let middleName = grabMiddleName(name: ("Mateusz",nil,"Matuszewski"))
if let theName = middleName {
    print(theName)
}

func greetByMiddleName(name: (first: String, middle: String?, last: String)) {
    guard let middleName = name.middle else {
        print("Witaj!")
        return
    }
    print("Cześć, \(middleName)!")
}
greetByMiddleName(name: ("Mateusz","Daniel","Matuszewski"))
