//
//  ViewController.swift
//  iTahDoodle
//
//  Created by Robert Górczyński on 09/10/16.
//  Copyright © 2016 Robert Górczyński. All rights reserved.
//

import UIKit

class ViewController: UIViewController {
    
    @IBOutlet var itemTextField: UITextField!
    @IBOutlet var tableView: UITableView!
    
    let todoList = TodoList()

    override func viewDidLoad() {
        super.viewDidLoad()
        // Wszelka konfiguracja dodatkowa po wczytaniu widoku, najczęściej z pliku nib.
        tableView.register(UITableViewCell.self, forCellReuseIdentifier: "Cell")
        tableView.dataSource = todoList
    }

    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Usunięcie wszelkich zasobów, które można później ponownie utworzyć.
    }
    
    @IBAction func addButtonPressed(sender: UIButton) {
        guard let text = itemTextField.text else {
            return
        }
        todoList.addItem(item: text)
        tableView.reloadData()
    }

}

