//
//  Person.swift
//  CyclicalAssets
//
//  Created by Robert Górczyński on 26/09/16.
//  Copyright © 2016 Robert Górczyński. All rights reserved.
//

import Foundation

class Person: CustomStringConvertible {
    let name: String
    let accountant = Accountant()
    var assets = [Asset]()
    
    var description: String {
        return "Osoba(\(name))"
    }
    
    init(name: String) {
        self.name = name
        
        accountant.netWorthChangedHandler = {
            [weak self] netWorth in
            
            self?.netWorthDidChange(netWorth: netWorth)
            return
        }
    }
    
    deinit {
        print("Egzemplarz \(self) został usunięty z pamięci.")
    }
    
    func takeOwnershipOfAsset(asset: Asset) {
        asset.owner = self
        assets.append(asset)
        accountant.gainedNewAsset(asset: asset)
    }
    
    func netWorthDidChange(netWorth: Double) {
        print("Wartość netto egzemplarza \(self) wynosi teraz \(netWorth).")
    }
}
