"""
Programowanie obiektowe w Pythonie 3

Rozdział 13., Testowanie oprogramowania obiektowego
"""
import logging
import logging.handlers
import time
import sys
from math import factorial

logger = logging.getLogger("app")


def work(i: int) -> int:
    logger.info("Silnia %d", i)
    f = factorial(i)
    logger.info("Silnia(%d) = %d", i, f)
    return f


if __name__ == "__main__":
    HOST, PORT = "localhost", 18842
    socket_handler = logging.handlers.SocketHandler(HOST, PORT)
    stream_handler = logging.StreamHandler(sys.stderr)
    logging.basicConfig(handlers=[socket_handler, stream_handler], level=logging.INFO)

    for i in range(10):
        work(i)

    logging.shutdown()
