# Programowanie obiektowe w Pythonie 3; Studium przypadku

Rozdział 4., Oczekując nieoczekiwanego

## Zgłaszanie wyjątków

### Zgłaszanie wyjątku

```python
>>> print "Witaj, świecie"
Traceback (most recent call last):
  ...
SyntaxError: Missing parentheses in call to 'print'. Did you mean print(...)?

```

```python
>>> x = 5 / 0
Traceback (most recent call last):
...
ZeroDivisionError: division by zero

>>> lst = [1,2,3]
>>> print(lst[3])
Traceback (most recent call last):
...
IndexError: list index out of range

>>> lst + 2
Traceback (most recent call last):
...
TypeError: can only concatenate list (not "int") to list

>>> lst.add
Traceback (most recent call last):
...
AttributeError: 'list' object has no attribute 'add'

>>> d = {'a': 'hello'}
>>> d['b']
Traceback (most recent call last):
...
KeyError: 'b'

>>> print(this_is_not_a_var)
Traceback (most recent call last):
...
NameError: name 'this_is_not_a_var' is not defined

```
### Efekty wyjątków

### Obsługa wyjątków

```python
>>> try: 
...     raise ValueError("Nieprawidłowy argument") 
... except ValueError as e: 
...     print(f"Argumenty przekazane do wyjątku to: {e.args}")
...
Argumenty przekazane do wyjątku to: ('Nieprawidłowy argument',)

```
### Hierarchia wyjątków

### Definiowanie własnych wyjątków

```python
>>> class InvalidWithdrawal(ValueError): 
...     pass 
 
>>> raise InvalidWithdrawal("Nie masz 500 zł na koncie")
Traceback (most recent call last):
...
InvalidWithdrawal: Nie masz 500 zł na koncie


```

```python

>>> from decimal import Decimal

>>> class InvalidWithdrawal(ValueError): 
...     def __init__(self, balance: Decimal, amount: Decimal) -> None: 
...         super().__init__(f"na koncie nie ma {amount} zł")
...         self.amount = amount 
...         self.balance = balance 
...     def overage(self) -> Decimal: 
...         return self.amount - self.balance 

>>> raise InvalidWithdrawal(Decimal('25.00'), Decimal('50.00'))
Traceback (most recent call last):
...
InvalidWithdrawal: na koncie nie ma 50.00 zł

>>> try: 
...     balance = Decimal('25.00')
...     raise InvalidWithdrawal(balance, Decimal('50.00')) 
... except InvalidWithdrawal as ex: 
...   print("Przykro nam, ale kwota, którą chcesz pobrać, "
...         "przekracza aktualny stan konta o "
...         f"{ex.overage()} zł")
...
Przykro nam, ale kwota, którą chcesz pobrać, przekracza aktualny stan konta o 25.00 zł


```

