"""
Programowanie obiektowe w Pythonie 3

Rozdział 2., Obiekty w Pythonie
"""
import ecommerce.products

# odwołanie bezwzględne.

product_1 = ecommerce.products.Product("fore")

# lub

from ecommerce.products import Product

product_2 = Product("main")

# lub

from ecommerce import products

product_3 = products.Product("mizzen")


test_1 = """
>>> import ecommerce.products
>>> product_1 = ecommerce.products.Product("fore")
>>> product_1.name
'fore'
"""

test_2 = """
>>> from ecommerce.products import Product
>>> product_2 = Product("main")
>>> product_2.name
'main'
"""

test_3 = """
>>> from ecommerce import products
>>> product_3 = products.Product("mizzen")
>>> product_3.name
'mizzen'
"""

disabled_test_path = """
Zmień nazwę na test_path dla testów które (a) nie 
kończą się powodzeniem lub (b) udostępniają ustawienie `PYTHONPATH`.

>>> import sys
>>> sys.path
[]

"""

__test__ = {name: case for name, case in globals().items() if name.startswith("test_")}
