"""
Programowanie obiektowe w Pythonie 3

Rozdział 2., Obiekty w Pythonie
"""

from typing import Optional

class Formatter:
    def format(self, string: str) -> str:
        pass

def format_string(string: str, formatter: Optional[Formatter] = None) -> str:
    """
    Formatuje łańcuch znaków używając obiektu formatter, który
    ma dysponować metodą format() pobierającą łańcuch znaków
    """

    class DefaultFormatter(Formatter):
        """Formatuje łańcuch znaków zapisując każde słowo z dużej litery"""

        def format(self, string: str) -> str:
            return str(string).title()

    if not formatter:
        formatter = DefaultFormatter()

    return formatter.format(string)


test_example = """
>>> hello_string = "Witaj, świecie! Jak się masz dzisiaj?"
>>> print(f" input: {hello_string}")
 input: Witaj, świecie! Jak się masz dzisiaj?
>>> print(f"output: {format_string(hello_string)}")
output: Witaj, Świecie! Jak Się Masz Dzisiaj?
"""

__test__ = {name: case for name, case in globals().items() if name.startswith("test_")}
