require 'gserver'

class ChatServer < GServer
  def initialize(*args)
    super(*args)
    
    # Rejestracja wszystkich identyfikatorw zalogowanych klientw
    # oraz kompletnego zapisu przebiegu czatu
    @@client_id = 0
    @@chat = []
  end
  
  def serve(io)
    # Zwikszenie wartoci identyfikatora klienta, aby kady klient posiada unikatowy identyfikator
    @@client_id += 1
    my_client_id = @@client_id
    my_position = @@chat.size
    
    io.puts("Witaj na czacie, kliencie #{@@client_id}!")
    
    # Wstawienie komunikatu do kolejki czatu, aby poinformowa,
    # e klient doczy do czatu
    @@chat << [my_client_id, "<docza do czatu>"]
    
    loop do 
      # Sprawdzenie co 5 sekund, czy odczytywane s jakie dane
      if IO.select([io], nil, nil, 2)
        # Jeli tak, pobranie danych i przetworzenie ich...
        line = io.gets
      
        # Jeeli uytkownik wpisa 'koniec', trzeba go odczy
        if line =~ /koniec/
          @@chat << [my_client_id, "<opuszcza czat>"]
          break
        end

        # Zamknicie serwera, jeeli wpisano sowo 'zamknij'
        self.stop if line =~ /zamknij/
      
        # Dodanie tekstu przesanego przez klienta do tablicy czatu
        # wraz z identyfikatorem klienta
        @@chat << [my_client_id, line]      
      else
        # Brak danych, naley wic wywietli wszystkie nowe wiersze ze strumienia czatu
        @@chat[my_position..(@@chat.size - 1)].each_with_index do |line, index|
          io.puts("#{line[0]} mwi: #{line[1]}")
        end
        
        # Przesunicie pozycji o jedn poza koniec tablicy
        my_position = @@chat.size
      end
    end
    
  end
end

server = ChatServer.new(1234)
server.start

loop do
  break if server.stopped?
end
