require 'webrick'
require 'bot'

# Klasa, ktra odpowiada na dania HTTP i komunikuje si z botem
class BotServlet < WEBrick::HTTPServlet::AbstractServlet
  
  # Prosty szablon HTML strony zawierajcej formularz i pole tekstowe,
  # w ktrym uytkownik moe wpisywa wypowiedzi adresowane do bota.
  # W kodzie uyto symbolu tekstowego (%RESPONSE%), dziki ktremu
  # nieco pniej atwo bdzie mona wstawi odpowiedzi bota.
  @@html = %q{
  <html><body>
    <form method="get">
      <h1>Rozmowa z Botem</h1>
      %RESPONSE%
      <p>
        <b>Uytkownik mwi:</b> <input type="text" name="line" size="40" />
        <input type="submit" />
      </p>
    </form>
  </body></html>
  }
  
  def do_GET(request, response)
    # Oznaczenie dania jako prawidowo obsuonego i zdefiniowanie MIME jako HTML
    response.status = 200
    response.content_type = "text/html"
    
    # Jeeli uytkownik wpisa jaki tekst, naley na niego odpowiedzie
    if request.query['line'] && request.query['line'].length > 1
      bot_text = $bot.response_to(request.query['line'].chomp)
    else
      bot_text = $bot.greeting
    end
    
    # Sformatowanie tekstu i wstawienie go do formularza HTML
    bot_text = %Q{<p><b>Bot mwi:</b> #{bot_text}</p>}
    response.body = @@html.sub(/\%RESPONSE\%/, bot_text)
  end
end

# Utworzenie serwera HTTP na porcie 1234 komputera lokalnego;
# serwer bdzie dostpny pod adresami http://localhost:1234/ oraz http://127.0.0.1:1234/
server = WEBrick::HTTPServer.new( :Port => 1234 )
$bot = Bot.new(:name => "Fred", :data_file => "fred.bot")
server.mount "/", BotServlet
trap("INT"){ server.shutdown }
server.start

