require 'test/unit'
require 'wordplay'

# Klasa testw jednostkowych dla biblioteki WordPlay
class TestWordPlay < Test::Unit::TestCase
  
  # Test poprawnoci podziau bloku wielu zda na pojedyncze sowa
  def test_sentences
    assert_equal(["a", "b", "c d", "e f g"], "a. b. c d. e f g.".sentences)

    test_text = %q{Hello. This is a test
of sentence separation. This is the end
of the test.}
    assert_equal("This is the end of the test", test_text.sentences[2])
  end
  
  # Test poprawnoci podziau zda na pojedyncze sowa
  def test_words
    assert_equal(%w{this is a test}, "this is a test".words)
    assert_equal(%w{these are mostly words}, "these are, mostly, words".words)
  end
  
  # Test poprawnoci wyboru najlepszego zdania z danych wejciowych
  def test_sentence_choice
    assert_equal('This is a great test',
                 WordPlay.best_sentence(['This is a test',
                                         'This is another test',
                                         'This is a great test'],
                                        %w{test great this}))
    assert_equal('This is a great test',
                 WordPlay.best_sentence(['This is a great test'],
                                        %w{still the best}))
  end
  
  # Test poprawnoci zamiany zaimkw przez metod switch_pronouns w prostych zdaniach
    assert_equal("i am a robot", WordPlay.switch_pronouns("you are a robot"))
    assert_equal("you are a person", WordPlay.switch_pronouns("i am a person"))
    assert_equal("i love you", WordPlay.switch_pronouns("you love me"))
  end
  
  # Test poprawnoci zamiany zaimkw przez metod switch_pronouns w zdaniach rozbudowanych
  def test_mixed_pronouns
    assert_equal("you gave me life", 
                 WordPlay.switch_pronouns("i gave you life"))
                 
    assert_equal("i am not what you are",
                 WordPlay.switch_pronouns("you are not what i am"))
  end

end

