#!/usr/bin/env ruby

require 'bot'
require 'cgi'

# Prosty szablon HTML strony zawierajcej formularz i pole tekstowe,
# w ktrym uytkownik moe wpisywa wypowiedzi adresowane do bota.
# W kodzie uyto symbolu tekstowego (%RESPONSE%), dziki ktremu
# nieco pniej atwo bdzie mona wstawi odpowiedzi bota.
html = %q{
  <html><body>
    <form method="get">
      <h1>Rozmowa z Botem</h1>
      %RESPONSE%
      <p>
        <b>Uytkownik mwi:</b> <input type="text" name="line" size="40" />
        <input type="submit" />
      </p>
    </form>
  </body></html>
}

# Skonfigurowanie rodowiska CGI i uatwienie dostpu do parametrw
cgi = CGI.new
params = cgi.params
line = params['line'] && params['line'].first

bot = Bot.new(:name => "Fred", :data_file => "fred.bot")

# Jeeli uytkownik wpisa jaki tekst, naley na niego odpowiedzie
if line && line.length > 1
  bot_text = bot.response_to(line.chomp)
else
  bot_text = bot.greeting
end
    
# Sformatowanie tekstu i wstawienie go do formularza HTML,
# a take zdefiniowanie nagwka MIME jako HTML
bot_text = %Q{<p><b>Bot mwi:</b> #{bot_text}</p>}
puts "Content-type: text/html\n\n"
puts html.sub(/\%RESPONSE\%/, bot_text)

