class Person
  attr_accessor :name, :job, :gender, :age
end

fred = Person.new
fred.name = "Fred Bloger"
fred.age = 45

laura = Person.new
laura.name = "Laura Kowalska"
laura.age = 23

require 'pstore'
store = PStore.new("storagefile")
store.transaction do
  store[:people] ||= Array.new
  store[:people] << fred
  store[:people] << laura
end

store = PStore.new("storagefile")
people = []
store.transaction do
  people = store[:people]
end

# Na tym etapie obiekty Person w tablicy people mona traktowa
# jako obiekty o charakterze lokalnym.
people.each do |person|
  puts person.name
end

