class Dungeon
  attr_accessor :player

  def initialize(player_name)
    @player = Player.new(player_name)
    @rooms = []
  end

  def add_room(reference, name, description, connections)
    @rooms << Room.new(reference, name, description, connections)
  end

  def start(location)
    @player. location = location
    show_current_description
  end

  def show_current_description
    puts find_room_in_dungeon(@player.location).full_description
  end

  def find_room_in_dungeon(reference)
    @rooms.detect { |room| room.reference == reference }
  end

  def find_room_in_direction(direction)
    find_room_in_dungeon(@player.location).connections[direction]
  end

  def go(direction)
    puts "Kierunek, w ktrym idziesz to " + direction.to_s
    @player.location = find_room_in_direction(direction)
    show_current_description
  end

  class Player
    attr_accessor :name, :location

    def initialize(name)
      @name = name
    end
  end

  class Room
    attr_accessor :reference, :name, :description, :connections

    def initialize(reference, name, description, connections)
      @reference = reference
      @name = name
      @description = description
      @connections = connections
    end

    def full_description
      @name + "\n\nMiejsce, w ktrym przebywasz to " + @description
    end
  end

end

# Utworzenie gwnego obiektu lochu
my_dungeon = Dungeon.new("Fred Bloger")

# Dodanie komnat lochu
my_dungeon.add_room(:largecave, "Dua pieczara", "dua, przestronna jaskinia", { :west => :smallcave })
my_dungeon.add_room(:smallcave, "Maa pieczara", "niewielka, ciasna jaskinia", { :east => :largecave })

# Rozpoczcie gry: umieszczenie gracza w duej pieczarze
my_dungeon.start(:largecave)

my_dungeon.show_current_description

my_dungeon.go(:west)

my_dungeon.go(:east)