# analyzer.rb -- Analizator tekstu

stop_words = %w{the a by on for of are with just but and to the my I has some in}
lines = File.readlines("text.txt")
line_count = lines.size
text = lines.join

# zliczenie znakw
character_count = text.length
character_count_nospaces = text.gsub(/\s+/, '').length

# zliczenie sw, zda i akapitw
word_count = text.split.length
sentence_count = text.split(/\.|\?|!/).length
paragraph_count = text.split(/\n\n/).length

# utworzenie listy sw z tekstu, ktre nie s sowami pomijanymi
# zliczenie tych sw i wyznaczenie procentowej iloci sw pomijanych
# w zbiorze wszystkich sw
all_words = text.scan(/\w+/)
good_words = all_words.select{ |word| !stop_words.include?(word) }
good_percentage = ((good_words.length.to_f / all_words.length.to_f) * 100).to_i

# podsumowanie - wyodrbnienie zda potencjalnie najbardziej znaczcych
sentences = text.gsub(/\s+/, ' ').strip.split(/\.|\?|\!/)
sentences_sorted = sentences.sort_by { |sentence| sentence.length }
one_third = sentences_sorted.length / 3
ideal_sentences = sentences_sorted.slice(one_third, one_third + 1)
ideal_sentences = ideal_sentences.select { |sentence| sentence =~ /is|are/ }

# wywietlenie uytkownikowi wynikw analizy
puts "#{line_count} wierszy"
puts "#{character_count} znakw"
puts "#{character_count_nospaces} znakw nie liczc spacji"
puts "#{word_count} sw"
puts "#{paragraph_count} akapitw"
puts "#{sentence_count} zda"
puts "#{sentence_count / paragraph_count} zda w jednym akapicie (rednio)"
puts "#{word_count / sentence_count} sw w jednym zdaniu (rednio)"
puts "#{good_percentage}% sw to sowa znaczce"
puts "Podsumowanie:\n\n" + ideal_sentences.join(". ")
puts "-- Koniec analizy"