/**
 *
 * @param image obiekt obrazka używany do rysowania
 * @param frames tablica opisująca ramki arkusza sprite'ów w formacie:
 * [
 * 	 [x, y, width, height, anchorX, anchorY] // - ramka 1
 * 	 [x, y, width, height, anchorX, anchorY] // - ramka 2
 * 	 ...
 * ]
 */
function SpriteSheet(image, frames) {
    this._image = image;
    this._frames = frames;
}

_p = SpriteSheet.prototype;

SpriteSheet.FRAME_X = 0;
SpriteSheet.FRAME_Y = 1;
SpriteSheet.FRAME_WIDTH = 2;
SpriteSheet.FRAME_HEIGHT = 3;
SpriteSheet.FRAME_ANCHOR_X = 4;
SpriteSheet.FRAME_ANCHOR_Y = 5;

/**
 * Rysuje ramkę z arkusza w podanym punkcie kontekstu (punkcie zaczepienia)
 * @param ctx kontekst do rysowania
 * @param index indeks ramki
 * @param x współrzędna x punktu zaczepienia 
 * @param y współrzędna y punktu zaczepienia
 */
_p.drawFrame = function(ctx, index, x, y) {
    var frame = this._frames[index];

    if (!frame)
        return;

    ctx.drawImage(this._image, frame[SpriteSheet.FRAME_X], frame[SpriteSheet.FRAME_Y],
        frame[SpriteSheet.FRAME_WIDTH], frame[SpriteSheet.FRAME_HEIGHT],
        x - frame[SpriteSheet.FRAME_ANCHOR_X], y - frame[SpriteSheet.FRAME_ANCHOR_Y],
        frame[SpriteSheet.FRAME_WIDTH], frame[SpriteSheet.FRAME_HEIGHT]);
};