/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.util.Log;
import org.apache.cordova.api.Plugin;
import org.apache.cordova.api.PluginResult;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class BatteryListener
extends Plugin {
    private static final String LOG_TAG = "BatteryManager";
    BroadcastReceiver receiver = null;
    private String batteryCallbackId = null;

    public PluginResult execute(String action, JSONArray args, String callbackId) {
        PluginResult.Status status = PluginResult.Status.INVALID_ACTION;
        String result = "Unsupported Operation: " + action;
        if (action.equals("start")) {
            if (this.batteryCallbackId != null) {
                return new PluginResult(PluginResult.Status.ERROR, "Battery listener already running.");
            }
            this.batteryCallbackId = callbackId;
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.intent.action.BATTERY_CHANGED");
            if (this.receiver == null) {
                this.receiver = new BroadcastReceiver(){

                    public void onReceive(Context context, Intent intent) {
                        BatteryListener.this.updateBatteryInfo(intent);
                    }
                };
                this.cordova.getActivity().registerReceiver(this.receiver, intentFilter);
            }
            PluginResult pluginResult = new PluginResult(PluginResult.Status.NO_RESULT);
            pluginResult.setKeepCallback(true);
            return pluginResult;
        }
        if (action.equals("stop")) {
            this.removeBatteryListener();
            this.sendUpdate(new JSONObject(), false);
            this.batteryCallbackId = null;
            return new PluginResult(PluginResult.Status.OK);
        }
        return new PluginResult(status, result);
    }

    public void onDestroy() {
        this.removeBatteryListener();
    }

    private void removeBatteryListener() {
        if (this.receiver != null) {
            try {
                this.cordova.getActivity().unregisterReceiver(this.receiver);
                this.receiver = null;
            }
            catch (Exception e) {
                Log.e((String)LOG_TAG, (String)("Error unregistering battery receiver: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private JSONObject getBatteryInfo(Intent batteryIntent) {
        JSONObject obj = new JSONObject();
        try {
            obj.put("level", batteryIntent.getIntExtra("level", 0));
            obj.put("isPlugged", batteryIntent.getIntExtra("plugged", -1) > 0);
        }
        catch (JSONException e) {
            Log.e((String)LOG_TAG, (String)e.getMessage(), (Throwable)e);
        }
        return obj;
    }

    private void updateBatteryInfo(Intent batteryIntent) {
        this.sendUpdate(this.getBatteryInfo(batteryIntent), true);
    }

    private void sendUpdate(JSONObject info, boolean keepCallback) {
        if (this.batteryCallbackId != null) {
            PluginResult result = new PluginResult(PluginResult.Status.OK, info);
            result.setKeepCallback(keepCallback);
            this.success(result, this.batteryCallbackId);
        }
    }
}

