use std::env;
use std::process;

fn main() {
    let args: Vec<String> = env::args().collect();

    let config = Config::build(&args).unwrap_or_else(|err| {
        println!("Problem z parsowaniem argumentw: {err}");
        process::exit(1);
    });

    println!("Wyszukiwanie {}", config.query);
    println!("W pliku {}", config.file_path);

    if let Err(e) = run(config) {
        println!("Bd aplikacji: {e}");
        process::exit(1);
    }
}
