use rand::Rng;
use std::cmp::Ordering;
use std::io;

fn main() {
    println!("Zgadnij liczb!");

    let secret_number = rand::thread_rng().gen_range(1..=100);

    println!("Sekretna liczba to: {secret_number}");

    loop {
        println!("Wpisz swj typ.");

        let mut guess = String::new();

        io::stdin()
            .read_line(&mut guess)
            .expect("Nie udao si odczyta linii");

        let guess: u32 = guess.trim().parse().expect("Please type a number!");

        println!("Twj typ to: {guess}");

        // ANCHOR: here
        // --fragment pominity--

        match guess.cmp(&secret_number) {
            Ordering::Less => println!("Za maa liczba!"),
            Ordering::Greater => println!("Za dua liczba!"),
            Ordering::Equal => {
                println!("Zgade!");
                break;
            }
        }
    }
}
// ANCHOR_END: here
