use std::env;
use std::process;

use minigrep::Config;

fn main() {
    let args: Vec<String> = env::args().collect();

    let config = Config::build(&args).unwrap_or_else(|err| {
        println!("Problem z parsowaniem argumentw: {err}");
        process::exit(1);
    });

    if let Err(e) = minigrep::run(config) {
        println!("Bd aplikacji: {e}");
        process::exit(1);
    }
}
