use std::env;
use std::fs;

// ANCHOR: here
fn main() {
    let args: Vec<String> = env::args().collect();

    let (query, file_path) = parse_config(&args);

    // --fragment pominity--
    // ANCHOR_END: here

    println!("Wyszukiwanie {}", query);
    println!("W pliku {}", file_path);

    let contents = fs::read_to_string(file_path)
        .expect("Odczyt pliku powinien by moliwy");

    println!("Z tekstem:\n{contents}");
    // ANCHOR: here
}

fn parse_config(args: &[String]) -> (&str, &str) {
    let query = &args[1];
    let file_path = &args[2];

    (query, file_path)
}
// ANCHOR_END: here
