pub struct Guess {
    value: i32,
}

impl Guess {
    pub fn new(value: i32) -> Guess {
        // ANCHOR: here
        if value < 1 {
            panic!(
                "Warto Guess musi by mniejsza lub rwna 100, otrzymano, got {}.",
                value
            );
        } else if value > 100 {
            panic!(
                "Warto Guess musi by wiksza lub rwna 1, otrzymano {}.",
                value
            );
        }
        // ANCHOR_END: here

        Guess { value }
    }
}

#[cfg(test)]
mod tests {
    use super::*;

    #[test]
    #[should_panic(expected = "mniejsza lub rwna 100")]
    fn greater_than_100() {
        Guess::new(200);
    }
}
