pub struct Guess {
    value: i32,
}

// ANCHOR: here
// --fragment pominity--

impl Guess {
    pub fn new(value: i32) -> Guess {
        if value < 1 {
            panic!(
                "Warto Guess musi by wiksza lub rwna 1, otrzymano {}.",
                value
            );
        } else if value > 100 {
            panic!(
                "Warto Guess musi by mniejsza lub rwna 100, otrzymano {}.",
                value
            );
        }

        Guess { value }
    }
}

#[cfg(test)]
mod tests {
    use super::*;

    #[test]
    #[should_panic(expected = "mniejsza lub rwna 100")]
    fn greater_than_100() {
        Guess::new(200);
    }
}
// ANCHOR_END: here
