// ANCHOR: here
fn first_word(s: &str) -> &str {
    let bytes = s.as_bytes();

    for (i, &item) in bytes.iter().enumerate() {
        if item == b' ' {
            return &s[0..i];
        }
    }

    &s[..]
}
// ANCHOR_END: here

fn main() {
    let my_string = String::from("witaj wiecie");

    // first_word dziaa na wycinkach typw `String`
    let word = first_word(&my_string[..]);

    let my_string_literal = "witaj wiecie";

    // first_word dziaa ne wycinkach literaw acuchw znakw
    let word = first_word(&my_string_literal[..]);

    // Poniewa literay acuchw znakw *s* ju wycinkami acuchw znakw,
    // to rwnie dziaa bez koniecznoci stosowania skadni wycinkw!
    let word = first_word(my_string_literal);
}
