// ANCHOR: here
fn first_word(s: &str) -> &str {
    // ANCHOR_END: here
    let bytes = s.as_bytes();

    for (i, &item) in bytes.iter().enumerate() {
        if item == b' ' {
            return &s[0..i];
        }
    }

    &s[..]
}

// ANCHOR: usage
fn main() {
    let my_string = String::from("witaj wiecie");

    // `first_word` dziaa na wycinkach `String, zarwno czciowych, jak i caych
    let word = first_word(&my_string[0..6]);
    let word = first_word(&my_string[..]);
    // `first_word` dziaa take na referencjach do `String`, ktre s
    // rwnowane z caymi wycinkami `String`
    let word = first_word(&my_string);

    let my_string_literal = "witaj wiecie";

    // `first_word` dziaa na wycinkach literaw acuchw znakw, zarwno czciowych, jak i caych
    let word = first_word(&my_string_literal[0..6]);
    let word = first_word(&my_string_literal[..]);

    // Poniewa literay acuchw znakw *s* ju wycinkami acuchw znakw,
    // to rwnie dziaa bez koniecznoci stosowania skadni wycinkw!
    let word = first_word(my_string_literal);
}
// ANCHOR_END: usage
