# Przykadowy kod z ksiki Ruby. Programowanie
require 'tk'
include Math

TkRoot.new do |root|
  title "Curves"
  geometry "400x400"

 TkCanvas.new(root) do |canvas|
  width 400
  height 400
  pack('side'=>'top', 'fill'=>'both', 'expand'=>'yes')

    points = [ ]

    10.upto(30) do |scale|
      (0.0).step(2*PI,0.1) do |i|
        new_x = 5*scale*sin(i) + 200 + scale*sin(i*2)
        new_y = 5*scale*cos(i) + 200 + scale*cos(i*6)
        points << [ new_x, new_y ]

        f = scale/5.0
        r = (Math.sin(f)+1)*127.0
        g = (Math.cos(2*f)+1)*127.0
        b = (Math.sin(3*f)+1)*127.0

        col = sprintf("#%02x%02x%02x", r.to_i, g.to_i, b.to_i)

        if points.size == 3
          TkcLine.new(canvas,
                      points[0][0], points[0][1],
                      points[1][0], points[1][1],
                      points[2][0], points[2][1],
                      'smooth'=>'on',
                      'width'=> 7,
                      'fill' => col,
                      'capstyle' => 'round')
         points.shift
        end

      end
    end
  end
end

Tk.mainloop

