# Przykadowy kod z ksiki Ruby. Programowanie
require 'strscan'

# Obsuga jzyka:
#   set <var> = <value>
#   get <var>

values = {}

loop do
  line = gets or break

  scanner = StringScanner.new(line.chomp)

  scanner.scan(/(get|set)\s+/) or fail "Brak polecenia"
  cmd = scanner[1]

  var_name = scanner.scan(/\w+/) or fail "Brak zmiennej"

  case cmd
  when "get"
    puts "#{var_name} => #{values[var_name].inspect}"

  when "set"
    scanner.skip(/\s+=\s+/) or fail "Brak '='"
    value = scanner.rest
    values[var_name] = value
  else
    fail cmd
  end

end

