# Przykadowy kod z ksiki Ruby. Programowanie
require 'rexml/document'
include REXML

xml = Document.new(File.open("demo.xml"))

cls = Element.new("class")
cls.attributes["name"] = "Rational"
cls.text = "Reprezentuje liczby rzeczywiste"

# Usuwa wzy potomne wza Integer i dodaje nowy wze
# poniej Integer.
int = xml.elements["//class[@name='Integer']"]

int.delete_at(1)
int.delete_at(2)

int.next_sibling = cls

# Zmienia wszystkie atrybuty 'name' na class_name
xml.elements.each("//class") do |c|
  c.attributes['class_name'] = c.attributes['name']
  c.attributes.delete('name')
end

# nastpnie zapisuje dane wraz z deklaracj XML na pocztku pliku
xml << XMLDecl.new
xml.write(STDOUT, 0)
