# Przykadowy kod z ksiki Ruby. Programowanie
require 'readline'
include Readline

require 'abbrev'
COMMANDS = %w{ exit inc dec }
ABBREV = COMMANDS.abbrev
Readline.completion_proc = proc do |string|
  ABBREV[string]
end
value = 0
loop do
  cmd = readline("wibble [#{value}]: ", true)
  break if cmd.nil?
  case cmd.strip
  when "exit"
    break
  when "inc"
    value += 1
  when "dec"
    value -= 1
  else
    puts "Niepoprawne polecenie #{cmd}"
  end
end

% ruby code/readline.rb
wibble [0]: inc
wibble [1]: <up-arrow> => inc
wibble [2]: d<tab>     => dec
wibble [1]: ^r i       => inc
wibble [2]: exit
%

