# Przykadowy kod z ksiki Ruby. Programowanie
require 'observer'

class CheckWaterTemperature # Okresowo sprawdza temperatur wody
  include Observable

  def run
    last_temp = nil
    loop do
      temp = Temperature.fetch # Zewntrzna klasa...
      puts "Aktualna temperatura: #{temp}"
      if temp != last_temp
        changed # informuje obserwatory
        notify_observers(Time.now, temp)
        last_temp = temp
      end
    end
  end
end

class Warner
  def initialize(&limit)
    @limit = limit
  end
  def update(time, temp) # Zwrotne wywoanie obserwatora
    if @limit.call(temp)
      puts "--- #{time.to_s}: Temperatura poza zakresem: #{temp}"
    end
  end
end

checker = CheckWaterTemperature.new
checker.add_observer(Warner.new {|t| t < 80})
checker.add_observer(Warner.new {|t| t > 120})
checker.run
