# Przykadowy kod z ksiki Ruby. Programowanie
require 'net/telnet'
tn = Net::Telnet.new({})
tn.login "guest", "secret"
tn.cmd "date"
tn.close   

tn = Net::Telnet.new({}) {|str| print str }
tn.login("guest", "secret") {|str| print str }
tn.cmd("date") {|str| print str }
tn.close

tn = Net::Telnet.new('Host' => 'time.nonexistent.org',
                     'Port' => 'time',
                     'Timeout' => 60,
                     'Telnetmode' => false)
atomic_time = tn.recv(4).unpack('N')[0]
puts "Czas atomowy: " + Time.at(atomic_time - 2208988800).to_s
puts "Czas lokalny: " + Time.now.to_s
   

