# Przykadowy kod z ksiki Ruby. Programowanie
require 'net/http'
require 'uri'

Net::HTTP.start('www.pragmaticprogrammer.com') do |http|
  response = http.get('/index.html')
  puts "Kod = #{response.code}"
  puts "Komunikat = #{response.message}"
  response.each {|key, val| printf "%-14s = %-40.40s\n", key, val }
  p response.body[400, 55]
end

response = Net::HTTP.get_response('www.pragmaticprogrammer.com',
          '/index.html')
puts "Kod = #{response.code}"
puts "Komunikat = #{response.message}"
response.each {|key, val| printf "%-14s = %-40.40s\n", key, val }
p response.body[400, 55]

def fetch(uri_str, limit=10)
  fail 'http redirect too deep' if limit.zero?
  puts "Prba: #{uri_str}"
  response = Net::HTTP.get_response(URI.parse(uri_str))
  case response
  when Net::HTTPSuccess
    response
  when Net::HTTPRedirection
    fetch(response['location'], limit1)
  else
    response.error!
  end
end

response = fetch('http://www.ruby-lang.org')
p response.body[500, 50]

Net::HTTP.start('blogs.pragprog.com') do |query|
  response = query.post("/pragdave", "terms=jolt&handler=searching")
  response.body.scan(%r{<span class="itemtitle">(.*?)</span>}m) do
  |title|
    puts title
  end
end
