# Przykadowy kod z ksiki Ruby. Programowanie
# Wywoanie przy uyciu "ruby example.rb --size 10k -v -q a.txt b.doc"
require 'getoptlong'

# okrela przyjmowane opcje i inicjuje
# analizator opcji
opts = GetoptLong.new(
  [ "--size", "-s", GetoptLong::REQUIRED_ARGUMENT ],
  [ "--verbose", "-v", GetoptLong::NO_ARGUMENT ],
  [ "--query", "-q", GetoptLong::NO_ARGUMENT ],
  [ "--check", "--valid", "-c", GetoptLong::NO_ARGUMENT ]
)

# przetwarzanie pobranych opcji
opts.each do |opt, arg|
  puts "Opcja: #{opt}, arg #{arg.inspect}"
end
puts "Pozostae argumenty: #{ARGV.join(', ')}"

