# Przykadowy kod z ksiki Ruby. Programowanie
class Special
  def initialize(valuable, volatile, precious)
    @valuable = valuable
    @volatile = volatile
    @precious = precious
  end

  def marshal_dump
    [ @valuable, @precious ]
  end
 
  def marshal_load(variables)
    @valuable = variables[0]
    @precious = variables[1]
    @volatile = "nieznany"
  end

  def to_s
    "#@valuable #@volatile #@precious"
  end
end

obj = Special.new("Witaj", "mj", "wiecie")
puts "Przed: obj = #{obj}"
data = Marshal.dump(obj)

obj = Marshal.load(data)
puts "Po: obj = #{obj}"

