# Przykadowy kod z ksiki Ruby. Programowanie
class Module
  @@docs = {}

  # Wywoywana w czasie napotkania definicji klasy
  def doc(str)
    @@docs[self.name] = self.name + ":\n" + str.gsub(/^\s+/, '')
  end

  # Wywoywana w celu pobrania dokumentacji
  def Module::doc(aClass)
    # Jeli metoda otrzyma klas lub modu, przeksztaci je na acuch znakw
    # (w przypadku klas operator '<=' przyrwnuje podan jednostk do samej klasy lub jej podtypu)
    aClass = aClass.name if aClass.class <= Module
    @@docs[aClass] || "Brak dokumentacji dla #{aClass}"
  end
end

class Example
  doc "Przykadowy acuch znakw dokumentacji"
  # ... reszta klasy
end

Module Another
  doc <<-edoc
    A to jest acuch znakw dokumentacji w module
  edoc
  # reszta moduu
end

puts Module::doc(Example)
puts Module::doc("Another")

